<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Rekening</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="<?php echo e(public_path('images/logokab.png')); ?>" height="80">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 24pt; font-weight: bold;">LAPORAN REKENING</div>
                <div style="font-size: 12pt;">Periode Tahun 2025</div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th>KODE</th>
                <th>URAIAN</th>
                <th>TARGET (Rp)</th>
                <th>REALISASI (Rp)</th>
                <th>CAPAIAN (%)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($row['kode']); ?></td>
                    <td><?php echo e($row['nama']); ?></td>
                    <td class="right">
                        <?php echo e($row['target'] > 0 ? number_format($row['target'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row['total'] > 0 ? number_format($row['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row['capaian']) ? number_format($row['capaian'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/laporan/laporan_per_rekening_pdf.blade.php ENDPATH**/ ?>