<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Rincian Pendapatan</title>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="<?php echo e(public_path('images/logokab.png')); ?>" height="80">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 24pt; font-weight: bold;">LAPORAN RINCIAN PENDAPATAN</div>
                <div style="font-size: 12pt;">MENURUT TANGGAL, OPD, KODE REKENING DAN RINCIAN PENDAPATAN</div>
                <div style="font-size: 12pt;">Periode
                    <?php echo e(\Carbon\Carbon::parse($daritanggal)->translatedFormat('d F Y')); ?>

                    Sampai
                    <?php echo e(\Carbon\Carbon::parse($sampaitanggal)->translatedFormat('d F Y')); ?>

                </div>
            </td>
        </tr>
    </table>
    <table border="1" cellspacing="0" cellpadding="5" width="100%">
        <thead>
            <tr>
                <th>Tanggal</th>
                <th>OPD</th>
                <th>Rekening</th>
                <th>Keterangan</th>
                <th>Nominal</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $transaksis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tanggal => $itemsByTanggal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $groupedByOpd = $itemsByTanggal->groupBy('nm_opd');
                    $totalTanggal = 0;
                ?>

                <?php $__currentLoopData = $groupedByOpd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $opd => $itemsByOpd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $firstOpdRow = true;
                        $subtotalOpd = 0;
                    ?>

                    <?php $__currentLoopData = $itemsByOpd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($firstOpdRow ? \Carbon\Carbon::parse($tanggal)->format('d/m/Y') : ''); ?></td>
                            <td><?php echo e($firstOpdRow ? $opd : ''); ?></td>
                            <td><?php echo e($item->rekening); ?></td>
                            <td><?php echo e($item->keterangan); ?></td>
                            <td style="text-align: right"><?php echo e(number_format($item->nilai, 2, ',', '.')); ?></td>
                        </tr>
                        <?php
                            $subtotalOpd += $item->nilai;
                            $totalTanggal += $item->nilai;
                            $firstOpdRow = false;
                        ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                
                <tr>
                    <td colspan="4" style="text-align: right"><strong>TOTAL TANGGAL
                            <?php echo e(\Carbon\Carbon::parse($tanggal)->format('d/m/Y')); ?></strong></td>
                    <td style="text-align: right"><strong><?php echo e(number_format($totalTanggal, 2, ',', '.')); ?></strong></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/laporan/laporan_rincian_pdf.blade.php ENDPATH**/ ?>