<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Rekening</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <h3 style="text-align: center;">LAPORAN REKENING</h3>
    <table>
        <thead>
            <tr>
                <th style="width: 20%;">KODE</th>
                <th>URAIAN</th>
                <th style="width: 25%;">JUMLAH (Rp)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="<?php echo e($row['bold'] ?? false ? 'bold' : ''); ?>"><?php echo e($row['kode']); ?></td>
                    <td class="<?php echo e($row['bold'] ?? false ? 'bold' : ''); ?>"><?php echo e($row['nama']); ?></td>
                    <td class="right <?php echo e($row['bold'] ?? false ? 'bold' : ''); ?>">
                        <?php if($row['total'] !== '' && $row['total'] != 0): ?>
                            <?php echo e(number_format($row['total'], 2, ',', '.')); ?>

                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/laporan/rekap_pdf.blade.php ENDPATH**/ ?>