<?php $__env->startSection('content_app'); ?>
    
    <div class="container-fluid">
        <div class="row justify">
            <div class="col-lg-4 mb-3 mb-md-1">
                <div class="card shadow-sm border-0 rounded-4">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1">Realisasi Pendapatan</h3>
                            <h5 class="mb-0 text-muted">Rp. <?php echo e(number_format($realisasi_pendapatan, 0, ',', '.')); ?></h5>
                        </div>
                        <div>
                            <div class="rounded-3 p-3">
                                <img src="<?php echo e(asset('images/realisasi_icon.png')); ?>" alt="" width="40"
                                    height="40">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4  mb-3 mb-md-1">
                <div class="card shadow-sm border-0 rounded-4">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1">Target Pendapatan</h3>

                            <h5 class="mb-0 text-muted">Rp. <?php echo e(number_format($target_pendapatan, 0, ',', '.')); ?></h5>

                        </div>
                        <div>
                            <div class="rounded-3 p-3">
                                <img src="<?php echo e(asset('images/pendapatan_icon.png')); ?>" alt="" width="40"
                                    height="40">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4  mb-3 mb-md-1">
                <div class="card shadow-sm border-0 rounded-4">
                    <div class="card-body d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="fw-bold mb-1">Presentase</h3>
                            <h5 class="mb-0 text-muted"><?php echo e(number_format($presentase_pendapatan, 2)); ?> %</h5>
                        </div>
                        <div>
                            <div class="rounded-3 p-3">
                                <img src="<?php echo e(asset('images/presentase_icon.png')); ?>" alt="" width="40"
                                    height="40">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid mt-3">
        <div class="row">
            <div class="col-lg-12">
                <div class="table-responsive ">
                    <table class="table table-bordered table-striped">
                        <thead class="table-primary text-center">
                            <tr class="justify-content-center">
                                <th rowspan="2">KODE</th>
                                <th rowspan="2">URAIAN</th>
                                <th colspan="2">TARGET </th>
                                <th rowspan="2">REALISASI (Rp)</th>
                                <th colspan="2">CAPAIAN (%)</th>
                            </tr>
                            <tr>
                                <th>TARGET INDUK (Rp)</th>
                                <th>TARGET PERUBAHAN (Rp)</th>
                                <th>CAPAIAN INDUK (%)</th>
                                <th>CAPAIAN PERUBAHAN (%)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $rows1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row1['kode']); ?></td>
                                    <td><?php echo e($row1['nama']); ?></td>
                                    <td class="right">
                                        <?php echo e($row1['targetinduk'] > 0 ? number_format($row1['targetinduk'], 2, ',', '.') : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e($row1['targetperubahan'] > 0 ? number_format($row1['targetperubahan'], 2, ',', '.') : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e($row1['total'] > 0 ? number_format($row1['total'], 2, ',', '.') : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e(isset($row1['capaianinduk']) ? number_format($row1['capaianinduk'], 2, ',', '.') . '%' : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e(isset($row1['capaianperubahan']) ? number_format($row1['capaianperubahan'], 2, ',', '.') . '%' : ''); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $rows2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($row2['kode']); ?></td>
                                    <td><?php echo e($row2['nama']); ?></td>
                                    <td class="right">
                                        <?php echo e($row2['targetinduk'] > 0 ? number_format($row2['targetinduk'], 2, ',', '.') : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e($row2['targetperubahan'] > 0 ? number_format($row2['targetperubahan'], 2, ',', '.') : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e($row2['total'] > 0 ? number_format($row2['total'], 2, ',', '.') : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e(isset($row2['capaianinduk']) ? number_format($row2['capaianinduk'], 2, ',', '.') . '%' : ''); ?>

                                    </td>
                                    <td class="right">
                                        <?php echo e(isset($row2['capaianperubahan']) ? number_format($row2['capaianperubahan'], 2, ',', '.') . '%' : ''); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $rows3; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td colspan="2" class="text-center"><b>Total Pendapatan</b></td>
                                    <td class="text-center text-bold">
                                        <b><?php echo e($row3['targetinduk'] > 0 ? number_format($row3['targetinduk'], 2, ',', '.') : ''); ?></b>
                                    </td>
                                    <td class="text-center text-bold">
                                        <b><?php echo e($row3['targetperubahan'] > 0 ? number_format($row3['targetperubahan'], 2, ',', '.') : ''); ?></b>
                                    </td>
                                    <td class="right text-bold">
                                        <b><?php echo e($row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : ''); ?></b>
                                    </td>
                                    <td class="right text-bold">
                                        <b><?php echo e(isset($row3['capaianinduk']) ? number_format($row3['capaianinduk'], 2, ',', '.') . '%' : ''); ?></b>
                                    </td>
                                    <td class="right text-bold">
                                        <b><?php echo e(isset($row3['capaianperubahan']) ? number_format($row3['capaianperubahan'], 2, ',', '.') . '%' : ''); ?></b>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <?php if (\Illuminate\Support\Facades\Blade::check('role', 'Admin')): ?>
        <div class="container-fluid mt-3">
            <div class="row">
                <div class="col-lg-12">
                    <div class="table-responsive ">
                        <table class="table table-bordered table-striped">
                            <thead class="table-primary text-center">
                                <tr>
                                    <th>No.</th>
                                    <th>OPD</th>
                                    <th>TARGET INDUK (Rp)</th>
                                    <th>TARGET PERUBAHAN (Rp)</th>
                                    <th>REALISASI (Rp)</th>
                                    <th>PRESENTASE INDUK(Rp)</th>
                                    <th>PRESENTASE PERUBAHAN(Rp)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $no = 1;
                                ?>
                                <?php $__currentLoopData = $dataperopd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $peropd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($no++); ?></td>
                                        <td><?php echo e($peropd->nm_opd); ?></td>
                                        <td class="right">
                                            <?php echo e($peropd->t_induk > 0 ? number_format($peropd->t_induk, 2, ',', '.') : ''); ?>

                                        </td>
                                        <td class="right">
                                            <?php echo e($peropd->t_perubahan > 0 ? number_format($peropd->t_perubahan, 2, ',', '.') : ''); ?>

                                        </td>
                                        <td class="right">
                                            <?php echo e($peropd->r > 0 ? number_format($peropd->r, 2, ',', '.') : ''); ?>

                                        </td>
                                        <td><?php echo e($peropd->p_induk); ?></td>
                                        <td><?php echo e($peropd->p_perubahan); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = $rows3; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td colspan="2" class="text-center"><b>Total Pendapatan</b></td>
                                        <td class="text-center text-bold">
                                            <b><?php echo e($row3['targetinduk'] > 0 ? number_format($row3['targetinduk'], 2, ',', '.') : ''); ?></b>
                                        </td>
                                        <td class="text-center text-bold">
                                            <b><?php echo e($row3['targetperubahan'] > 0 ? number_format($row3['targetperubahan'], 2, ',', '.') : ''); ?></b>
                                        </td>
                                        <td class="right text-bold">
                                            <b><?php echo e($row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : ''); ?></b>
                                        </td>
                                        <td class="right text-bold">
                                            <b><?php echo e($row3['capaianinduk'] > 0 ? number_format($row3['capaianinduk'], 2, ',', '.') : ''); ?></b>
                                        </td>
                                        <td class="right text-bold">
                                            <b><?php echo e($row3['capaianperubahan'] > 0 ? number_format($row3['capaianperubahan'], 2, ',', '.') : ''); ?></b>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/dashboard.blade.php ENDPATH**/ ?>