<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Bupati</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="<?php echo e(public_path('images/logokab.png')); ?>" height="80">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 20pt; font-weight: bold;">DAFTAR REKAPITULASI PENERIMAAN PENDAPATAN DAERAH</div>
                <div style="font-size: 18pt; font-weight: bold;">PEMERINTAH KABUPATEN BOJONEGORO</div>
                <div style="font-size: 16pt;">Tahun Anggaran 2025</div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th rowspan="2">KODE</th>
                <th rowspan="2">URAIAN</th>
                <th colspan="2">TARGET (Rp)</th>
                <th rowspan="2">REALISASI (Rp)</th>
                <th colspan="2">CAPAIAN (%)</th>
            </tr>
            <tr>
                <th>TARGET INDUK (Rp)</th>
                <th>TARGET PERUBAHAN (Rp)</th>
                <th>CAPAIAN INDUK(%)</th>
                <th>CAPAIAN INDUK(%)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows1; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row1): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr <?php if($row1['bold']): ?> style="font-weight:bold;" <?php endif; ?>>
                    <td><?php echo e($row1['kode']); ?></td>
                    <td><?php echo e($row1['nama']); ?></td>
                    <td class="right">
                        <?php echo e($row1['targetinduk'] > 0 ? number_format($row1['targetinduk'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row1['targetperubahan'] > 0 ? number_format($row1['targetperubahan'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row1['total'] > 0 ? number_format($row1['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row1['capaianinduk']) ? number_format($row1['capaianinduk'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row1['capaianperubahan']) ? number_format($row1['capaianperubahan'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $rows2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr <?php if($row2['bold']): ?> style="font-weight:bold;" <?php endif; ?>>
                    <td><?php echo e($row2['kode']); ?></td>
                    <td><?php echo e($row2['nama']); ?></td>
                    <td class="right">
                        <?php echo e($row1['targetinduk'] > 0 ? number_format($row1['targetinduk'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row1['targetperubahan'] > 0 ? number_format($row1['targetperubahan'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row1['total'] > 0 ? number_format($row1['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row1['capaianinduk']) ? number_format($row1['capaianinduk'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row1['capaianperubahan']) ? number_format($row1['capaianperubahan'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $rows3; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right">
                        <?php echo e($row3['targetinduk'] > 0 ? number_format($row3['targetinduk'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row3['targetperubahan'] > 0 ? number_format($row3['targetperubahan'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row3['capaianinduk']) ? number_format($row3['capaianinduk'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row3['capaianperubahan']) ? number_format($row3['capaianperubahan'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <br><br>
    <table width="100%" style="border: none; margin-top: 40px;">
        <tr>
            <td style="border: none; width: 60%;"></td>
            <td style="border: none; text-align: center;">
                Bojonegoro, <?php echo e(\Carbon\Carbon::now()->translatedFormat('d F Y')); ?><br>
                KEPALA BADAN PENDAPATAN DAERAH,<br>
                KABUPATEN BOJONEGORO<br><br><br><br>
                <u><b>YUSNITA LIASARI, ST, M.Si</b></u><br>
                Pembina Utama Muda
                <br>
                NIP. 19721127 199803 1 006
            </td>
        </tr>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/laporan/laporan_bupati_kab_papbd_pdf.blade.php ENDPATH**/ ?>