<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\LaporanController;
use App\Http\Controllers\OpdController;
use App\Http\Controllers\PendapatanController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\Refrek6Controller;
use App\Http\Controllers\TargetController;
use App\Exports\RekeningExport;
use App\Http\Controllers\PembiayaanController;
use Maatwebsite\Excel\Facades\Excel;

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::group(['middleware' => ['auth']], function () {
    Route::resource('roles', RoleController::class);
    Route::resource('users', UserController::class);
    Route::resource('refrek6', Refrek6Controller::class);
    Route::resource('pendapatan', PendapatanController::class);
    Route::resource('opd', OpdController::class);
    Route::resource('laporan', LaporanController::class);
    Route::resource('target', TargetController::class);
    Route::resource('pembiayaan', PembiayaanController::class);
});

Route::post('/laporanbupatiopdpdf', [LaporanController::class, 'laporanBupatiOpdPdf'])->name('laporanBupatiOpdPdf');
Route::get('/laporanbupatiopd', [LaporanController::class, 'laporanBupatiOpd'])->name('laporanBupatiOpd');
Route::get('/laporanbupatiexcel', [LaporanController::class, 'laporanBupatiExcel'])->name('laporanBupatiExcel');
Route::get('/laporanbupati', [LaporanController::class, 'laporanBupati'])->name('laporanBupati');
Route::post('/laporanbupatikab', [LaporanController::class, 'laporanRekeningBupati'])->name('laporanRekeningBupati');
Route::get('/laporanbupatiopdex', [LaporanController::class, 'laporanBupatiOpdExcel'])->name('laporanBupatiOpdEx');
Route::post('/laporanbupatikabexcel', [LaporanController::class, 'exportExcelLaporanRekeningBupati'])->name('laporanRekeningBupatiExcel');
Route::post('/laporanbupatiopdexcel', [LaporanController::class, 'exportExcelLaporanBupatiOpd'])->name('laporanBupatiOpdExcel');

Route::get('/laporangubernur', [LaporanController::class, 'laporanGubernur'])->name('laporanGubernur');
Route::post('/laporangubernurpdf', [LaporanController::class, 'laporanGubernurPdf'])->name('laporanGubernurPdf');
Route::post('/laporangubernurexcel', [LaporanController::class, 'exportExcelLaporanGubernur'])->name('laporanGubernurExcel');
Route::post('/laporanrinciangubernurpdf', [LaporanController::class, 'laporanGubernurRincianPdf'])->name('laporanGubernurRincianPdf');
Route::post('/laporanrinciangubernurexcel', [LaporanController::class, 'exportExcelLaporanRincianGubernur'])->name('laporanRincianGubernurExcel');
Route::get('/laporangubernuropd', [LaporanController::class, 'laporanGubernurOpd'])->name('laporanGubernurOpd');
Route::post('/laporangubernuropdpdf', [LaporanController::class, 'laporanGubernurOpdPdf'])->name('laporanGubernurOpdPdf');
Route::post('/laporangubernuropdexcel', [LaporanController::class, 'exportExcelLaporanGubernurOpd'])->name('laporanGubernurOpdExcel');

Route::get('/laporanperrincian', [LaporanController::class, 'laporanRincianKab'])->name('laporanPerRincian');
Route::post('/laporanperrincianpdf', [LaporanController::class, 'laporanRincianKabPdf'])->name('laporanRincianKabPdf');
Route::post('/laporanperrincianexcel', [LaporanController::class, 'exportExcelTransaksiHarian'])->name('laporanRincianKabExcel');
Route::get('/laporanperrincianpendapatan', [LaporanController::class, 'laporanRincianPendapatan'])->name('laporanRincianPendapatan');
Route::post('/laporanrincianpendapatanexcel', [LaporanController::class, 'exportExcelRincianPendapatan'])->name('exportExcelRincianPendapatan');
Route::get('/laporanperrinciantarget', [LaporanController::class, 'laporanRincianTarget'])->name('laporanRincianTarget');
Route::post('/laporantargetpendapatanexcel', [LaporanController::class, 'exportExcelTargetPendapatan'])->name('exportExcelTargetPendapatan');

Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

Route::get('/main', [App\Http\Controllers\HomeController::class, 'template'])->name('template');
