@extends('layouts.default')

@section('content_app')
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12 margin-tb">
                        <div class="pull-left">
                            <h2 class="m-0 font-weight-bold text-dark">Halaman User</h2>
                        </div>
                        <div class="text-right">
                            <a class="btn btn-primary mb-2" href="{{ route('users.create') }}"><i class="fa fa-plus"></i>
                                Create New
                                User</a>
                        </div>
                    </div>
                </div>

                @session('success')
                    <div class="alert alert-success" role="alert">
                        {{ $value }}
                    </div>
                @endsession
            </div>
        </div>
        <div class="card-body">
            <table class="table table-bordered">
                <tr>
                    <th>No</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Roles</th>
                    <th width="280px">Action</th>
                </tr>
                @foreach ($data as $key => $user)
                    <tr>
                        <td>{{ ++$i }}</td>
                        <td>{{ $user->name }}</td>
                        <td>{{ $user->email }}</td>
                        <td>
                            @if (!empty($user->getRoleNames()))
                                @foreach ($user->getRoleNames() as $v)
                                    <label class="badge bg-success text-white">{{ $v }}</label>
                                @endforeach
                            @endif
                        </td>
                        <td>
                            <a class="btn btn-info btn-sm" href="{{ route('users.show', $user->id) }}"><i
                                    class="fas fa-list"></i> Show</a>
                            <a class="btn btn-warning btn-sm" href="{{ route('users.edit', $user->id) }}"><i
                                    class="fas fa-pen"></i> Edit</a>
                            <form method="POST" action="{{ route('users.destroy', $user->id) }}" style="display:inline">
                                @csrf
                                @method('DELETE')

                                <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i>
                                    Delete</button>
                            </form>
                        </td>
                    </tr>
                @endforeach
            </table>

            {!! $data->links('pagination::bootstrap-5') !!}
        </div>
    </div>
@endsection
