@extends('layouts.default')

@section('content_app')
    <div class="card shadow">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h2 class="m-0 font-weight-bold text-dark">Edit Target Pendapatan</h2>
                </div>
                <div class="col-md-6 text-right">
                    <a href="{{ route('target.index') }}" class="btn btn-danger rounded text-right"><i
                            class="fas fa-backward"></i></a>
                </div>
            </div>
        </div>
        @if (count($errors) > 0)
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body">
            <form method="POST" action="{{ route('target.update', $target->id_target) }}">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <strong>Tahun:</strong>
                            <select name="tahun" class="form-control">
                                <option value="{{ $target->tahun }}">{{ $target->tahun }}</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <strong>JADWAL</strong>
                            <select id="jadwal" name="jadwal" class="form-control">
                                <option value="{{ $target->kd_jadwal }}">{{ $target->jadwal }}
                                </option>
                                @foreach ($jadwal as $value => $jdl)
                                    <option value="{{ $jdl->kd_jadwal }}">
                                        {{ $jdl->jadwal }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <strong>OPD:</strong>
                            <select id="select_opd" name="opd" class="form-control">
                                <option value="{{ $target->kd_opd }}">{{ $target->nm_opd }}
                                </option>
                                @foreach ($d_opd as $value => $opd)
                                    <option value="{{ $opd->kd_opd }}">
                                        {{ $opd->nm_opd }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Rekening:</strong>
                            <select id="select_rekening" name="rekening" class="form-control">
                                <option value="{{ $target->kd_rekening }}">
                                    {{ $target->kd_rekening . ' ' . $target->nm_rek6 }}
                                </option>
                                @foreach ($rekening as $value => $rek)
                                    <option
                                        value="{{ $rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6 }}">
                                        {{ $rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6 }}
                                        {{ $rek->nm_rek6 }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Keterangan</strong>
                            <input type="text" name="keterangan" placeholder="Keterangan" class="form-control"
                                value="{{ $target->keterangan }}">
                        </div>
                    </div>

                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Nilai:</strong>
                            <input type="text" name="nilai" placeholder="Nilai" class="form-control"
                                oninput="formatRibuan(this)" value="{{ $target->nilai }}">
                            <input type="hidden" id="nilai" name="nilai">
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 text-right">
                        <button type="submit" class="btn btn-primary btn-md mt-2 mb-3"><i class="fas fa-sd-card"></i>
                            Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#select_rekening').select2({
                placeholder: "Cari Rekening",
                allowClear: true
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#select_opd').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
    <script>
        function formatRibuan(el) {
            // Hapus semua karakter selain angka
            let raw = el.value.replace(/[^0-9]/g, '');

            // Simpan ke input hidden (tanpa format)
            document.getElementById('nilai').value = raw;

            // Format tampilan input
            el.value = raw.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
        }
    </script>
@endsection
