@extends('layouts.default')

@section('content_app')
    @session('success')
        <div class="alert alert-success" role="alert" id="success-alert">
            {{ $value }}
        </div>
        <script>
            setTimeout(function() {
                const alert = document.getElementById('success-alert');
                if (alert) {
                    alert.style.display = 'none';
                }
            }, 5000);
        </script>
    @endsession
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <h2 class="m-0 font-weight-bold text-dark">Halaman Pendapatan</h2>
                    </div>
                    <div class="col-md-6 text-right">

                    </div>
                </div>
            </div>

        </div>
        <div class="card-body">
            <h4 class="m-0 font-weight-bold text-dark">Data B IX</h4>
            <div class="text-right">
                <a href="{{ route('pendapatan.create') }}" class="btn btn-primary">Input Pendapatan</a>
            </div>
            <div class="table-responsive py-3">
                <table id="tabelRekening" class="table table-bordered" width="100%" cellspacing="0">
                    <thead class="thead-light">
                        <tr>
                            <th>Tanggal</th>
                            <th>Kode Rekening</th>
                            <th>Nama Rekening</th>
                            <th>OPD</th>
                            <th>Keterangan</th>
                            <th>Jumlah (Rp)</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($data as $row)
                            <tr>
                                <td>{{ $row->tgl_transaksi }}</td>
                                <td>{{ $row->kd_rekening }}</td>
                                <td>{{ $row->nm_rek6 }}</td>
                                <td>{{ $row->nm_opd }}</td>
                                <td>{{ $row->keterangan }}</td>
                                <td>Rp {{ number_format($row->nilai, 0, ',', '.') }}</td>
                                <td>
                                    <a class="btn btn-warning btn-sm rounded-circle" data-bs-toggle="tooltip-edit"
                                        data-bs-placement="top" title="Edit Pendapatan"
                                        href="{{ route('pendapatan.edit', $row->id_transaksi) }}"><i
                                            class="fas fa-pen"></i></a>
                                    <form method="POST" action="{{ route('pendapatan.destroy', $row->id_transaksi) }}"
                                        style="display:inline">
                                        @csrf
                                        @method('DELETE')

                                        <button type="submit" class="btn btn-danger btn-sm rounded-circle"
                                            data-bs-toggle="tooltip-delete" data-bs-placement="top"
                                            title="Delete Pendapatan"><i class="fas fa-trash"></i></button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@section('scripts')
    <!-- DataTables JS -->
    <script>
        $(document).ready(function() {
            $('#tabelRekening').DataTable({
                "pageLength": 10,
                "language": {
                    "search": "Cari:",
                    "lengthMenu": "Tampilkan _MENU_ entri",
                    "info": "Menampilkan _START_ sampai _END_ dari _TOTAL_ entri",
                    "paginate": {
                        "first": "Awal",
                        "last": "Akhir",
                        "next": "Berikutnya",
                        "previous": "Sebelumnya"
                    },
                    "zeroRecords": "Data tidak ditemukan",
                    "infoEmpty": "Menampilkan 0 sampai 0 dari 0 entri",
                    "infoFiltered": "(difilter dari _MAX_ total entri)"
                }
            });
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip-edit"]'));
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
        document.addEventListener('DOMContentLoaded', function() {
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip-delete"]'));
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
@endsection
{{--  @foreach ($transaksi as $tanggal => $perTanggal)
            <div class="mt-4">
                <h5 class="text-primary">📅 Tanggal: {{ $tanggal }}</h5>

                @foreach ($perTanggal as $rekening => $data)
                    <div class="ms-3">
                        <strong>🔸 Rekening:
                            {{ $rekening }}
                            - {{ $data->first()->nm_rek6 }}</strong>

                        <table class="table table-sm table-bordered mt-2">
                            <thead>
                                <tr>
                                    <th style="width: 30%;">OPD</th>
                                    <th style="width: 35%;">Keterangan</th>
                                    <th style="width: 20%;">Jumlah (Rp)</th>
                                    <th style="width: 15%;">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($data as $row)
                                    <tr>
                                        <td>{{ $row->nm_opd }}</td>
                                        <td>{{ $row->keterangan }}</td>
                                        <td>Rp {{ number_format($row->nilai, 0, ',', '.') }}</td>
                                        <td>
                                            <a class="btn btn-warning btn-sm text-white"
                                                href="{{ route('pendapatan.edit', $row->id_transaksi) }}"><i
                                                    class="fa-solid fa-pen-to-square"></i> Edit</a>
                                            <form method="POST"
                                                action="{{ route('pendapatan.destroy', $row->id_transaksi) }}"
                                                style="display:inline">
                                                @csrf
                                                @method('DELETE')

                                                <button type="submit" class="btn btn-danger btn-sm"><i
                                                        class="fa-solid fa-trash"></i> Delete</button>
                                            </form>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endforeach

                {{-- Total per tanggal --}}
{{-- <div class="ms-3 mt-2 fw-bold text-success">
                    💰 Total {{ $tanggal }}: Rp {{ number_format($totals[$tanggal] ?? 0, 0, ',', '.') }}
                </div>
            </div>
        @endforeach
    </div>  --}}
{{-- <table class="table table-bordered" style="padding-bottom: 100px">
        <thead class="text-center">
            <tr>
                <th>Tanggal</th>
                <th>Kode Rekening</th>
                <th>Nama Rekening</th>
                <th>OPD</th>
                <th>Keterangan</th>
                <th>Jumlah (Rp)</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data as $row)
                <tr>
                    <td>{{ $row->tgl_transaksi }}</td>
                    <td>{{ $row->kd_rekening }}</td>
                    <td>{{ $row->nm_rek6 }}</td>
                    <td>{{ $row->nm_opd }}</td>
                    <td>{{ $row->keterangan }}</td>
                    <td>Rp {{ number_format($row->nilai, 0, ',', '.') }}</td>
                    <td>
                        <a class="btn btn-warning btn-sm text-white"
                            href="{{ route('pendapatan.edit', $row->id_transaksi) }}"><i
                                class="fa-solid fa-pen-to-square"></i> Edit</a>
                        <form method="POST" action="{{ route('pendapatan.destroy', $row->id_transaksi) }}"
                            style="display:inline">
                            @csrf
                            @method('DELETE')

                            <button type="submit" class="btn btn-danger btn-sm"><i class="fa-solid fa-trash"></i>
                                Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table> --}}


@endsection
