@extends('layouts.default')

@section('content_app')
    <div class="card shadow">
        <div class="card-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <h2 class="m-0 font-weight-bold text-dark">Tambah Pembiayaan</h2>
                    </div>
                    <div class="col-md-6 text-right">
                        <a href="{{ route('pembiayaan.index') }}" class="btn btn-danger rounded text-right"><i
                                class="fas fa-backward"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('pembiayaan.store') }}">
                @csrf
                <div class="row">
                    <div class="col-md-2">
                        <strong>Tahun</strong>
                    </div>
                    <div class="col-md-10">
                        <select name="tahun" class="form-control">
                            <option value="2025">2025</option>
                        </select>
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Tanggal</strong>
                    </div>
                    <div class="col-md-10  mt-3">
                        <input type="date" name="tgl_transaksi" placeholder="Name" class="form-control">
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Keterangan</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <input type="text" name="keterangan" placeholder="Keterangan" class="form-control">
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Nilai</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <input type="text" id="nilai_format" placeholder="Nilai" class="form-control"
                            oninput="formatRibuan(this)">
                        <input type="hidden" id="nilai" name="nilai">
                    </div>
                    <div class="col-md-12 text-right">
                        <button type="submit" class="btn btn-primary mt-2 mb-3"><i class="fas fa-sd-card"></i>
                            Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        function formatRibuan(input) {
            // Simpan posisi kursor
            const cursorPos = input.selectionStart;

            // Ambil hanya angka dan koma (hanya satu koma diizinkan)
            let raw = input.value.replace(/[^0-9,]/g, '');

            // Pisahkan bagian ribuan dan desimal
            let parts = raw.split(',');

            let ribuan = parts[0];
            let desimal = parts[1] !== undefined ? parts[1] : '';

            // Format angka ribuan
            let formattedRibuan = ribuan.replace(/\B(?=(\d{3})+(?!\d))/g, '.');

            // Gabungkan kembali
            let formatted = desimal !== '' ? `${formattedRibuan},${desimal}` : formattedRibuan;

            input.value = formatted;

            // Simpan dalam hidden field sebagai format numerik (1200,50 jadi 1200.50)
            let numeric = ribuan.replace(/\./g, '') + (desimal !== '' ? '.' + desimal : '');
            document.getElementById('nilai').value = numeric;

            // Atur ulang posisi kursor agar nyaman
            input.setSelectionRange(cursorPos, cursorPos);
        }
    </script>
@endsection
