<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Bupati</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <td width="15%" align="left" style="border: none;">
            <img src="{{ public_path('images/logokab.png') }}" height="80">
        </td>
        <td width="85%" align="center" style="border: none;">
            <div style="font-size: 18pt; font-weight: bold;">REKAPITULASI LAPORAN REALISASI PENERIMAAN PENDAPATAN DAERAH
                KABUPATEN BOJONEGORO</div>
            <div style="font-size: 18pt; font-weight: bold;">
                @foreach ($ref_opd as $ropd)
                    {{ $ropd->nm_opd }}
                @endforeach
            </div>
            <div style="font-size: 12pt;">KEADAAN S/D
                {{ strtoupper(\Carbon\Carbon::parse($end)->translatedFormat('d F Y')) }}
            </div>
        </td>

    </table>
    <table border="1" cellspacing="0" cellpadding="5" style="font-size: 12px; width: 100%;">
        <thead style="text-align: center; background-color: #e5e5e5;">
            <tr class="text-center">
                <th rowspan="2">KODE REKENING</th>
                <th rowspan="2">URAIAN PENERIMAAN</th>
                <th colspan="2">TARGET<br>APBD TAHUN </th>
                <th colspan="3">REALISASI REKENING</th>
                <th colspan="2">APBD<br>%</th>
            </tr>
            <tr class="text-center">
                <th>INDUK</th>
                <th>PERUBAHAN</th>
                <th>S/D BULAN LALU<br>S/D {{ strtoupper(\Carbon\Carbon::parse($start)->translatedFormat('d F Y')) }}
                </th>
                <th>BULAN INI<br>1 S/D {{ strtoupper(\Carbon\Carbon::parse($end)->translatedFormat('d F Y')) }}</th>
                <th>S/D BULAN INI<br>S/D {{ strtoupper(\Carbon\Carbon::parse($end)->translatedFormat('d F Y')) }}
                </th>
                <th>INDUK</th>
                <th>PERUBAHAN</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rows2 as $row2)
                <tr @if ($row2['bold']) style="font-weight:bold;" @endif>
                    <td>{{ $row2['kode'] }}</td>
                    <td>{{ $row2['nama'] }}</td>
                    <td class="right">
                        {{ $row2['targetinduk'] > 0 ? number_format($row2['targetinduk'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row2['targetperubahan'] > 0 ? number_format($row2['targetperubahan'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row2['totalbulanlalu'] > 0 ? number_format($row2['totalbulanlalu'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row2['totalbulanini'] > 0 ? number_format($row2['totalbulanini'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row2['total'] > 0 ? number_format($row2['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row2['capaianinduk']) ? number_format($row2['capaianinduk'], 2, ',', '.') . '%' : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row2['capaianperubahan']) ? number_format($row2['capaianperubahan'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
            @foreach ($rows3 as $row3)
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right text-bold">
                        <b>{{ $row3['targetinduk'] > 0 ? number_format($row3['targetinduk'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ $row3['targetperubahan'] > 0 ? number_format($row3['targetperubahan'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ $row3['totalbulanlalu'] > 0 ? number_format($row3['totalbulanlalu'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ $row3['totalbulanini'] > 0 ? number_format($row3['totalbulanini'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ $row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ isset($row3['capaianinduk']) ? number_format($row3['capaianinduk'], 2, ',', '.') . '%' : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ isset($row3['capaianperubahan']) ? number_format($row3['capaianperubahan'], 2, ',', '.') . '%' : '' }}</b>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
