@extends('layouts.default')

@section('content_app')
    @if (count($errors) > 0)
        <div class="alert alert-danger">
            <strong>Maaf !!!</strong> Semua data harus diisi untuk mencetak laporan !!!
            {{-- <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul> --}}
        </div>
    @endif
    <div class="row">
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <h2 class="m-0 font-weight-bold text-dark">Laporan Gubernur Per OPD</h2>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('laporanGubernurOpdPdf') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-2 mt-3">
                                <strong>Tahun</strong>
                            </div>
                            <div class="col-md-10 mt-3">
                                <select id="" name="tahun" class="form-control">
                                    <option value="2025">2025</option>
                                    <option value="2026">2026</option>
                                    <option value="2027">2027</option>
                                </select>
                            </div>
                            <div class="col-md-2 mt-3">
                                <strong>Jadwal</strong>
                            </div>
                            <div class="col-md-10 mt-3">
                                <select id="" name="jadwal" class="form-control">
                                    <option value="">-- Pilih Laporan --</option>
                                    @foreach ($jadwal as $jdwl => $jdl)
                                        <option value="{{ $jdl->kd_jadwal }}">
                                            {{ $jdl->jadwal }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 mt-3">
                                <strong>Bulan</strong>
                            </div>
                            <div class="col-md-10  mt-3">
                                <select name="bulan" class="form-control">
                                    <option value="01">Januari</option>
                                    <option value="02">Februari</option>
                                    <option value="03">Maret</option>
                                    <option value="04">April</option>
                                    <option value="05">Mei</option>
                                    <option value="06">Juni</option>
                                    <option value="07">Juli</option>
                                    <option value="08">Agustus</option>
                                    <option value="09">September</option>
                                    <option value="10">Oktober</option>
                                    <option value="11">November</option>
                                    <option value="12">Desember</option>
                                </select>
                            </div>
                            <div class="col-md-2 mt-3">
                                <strong>OPD</strong>
                            </div>
                            <div class="col-md-10 mt-3">
                                <select id="select_opd" name="opd" class="form-control">
                                    <option value="">-- Pilih OPD --</option>
                                    @foreach ($d_opd as $value => $opd)
                                        <option value="{{ $opd->kd_opd }}">
                                            {{ $opd->nm_opd }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-danger mt-2 mb-3"><i class="fas fa-file-pdf"></i>
                                    Cetak</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card shadow">
                <div class="card-header">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col-md-12">
                                <h2 class="m-0 font-weight-bold text-dark">Laporan Gubernur Per OPD</h2>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('laporanGubernurOpdExcel') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-2 mt-3">
                                <strong>Tahun</strong>
                            </div>
                            <div class="col-md-10 mt-3">
                                <select id="" name="tahun" class="form-control">
                                    <option value="2025">2025</option>
                                    <option value="2026">2026</option>
                                    <option value="2027">2027</option>
                                </select>
                            </div>
                            <div class="col-md-2 mt-3">
                                <strong>Jadwal</strong>
                            </div>
                            <div class="col-md-10 mt-3">
                                <select id="" name="jadwal" class="form-control">
                                    <option value="">-- Pilih Laporan --</option>
                                    @foreach ($jadwal as $jdwl => $jdl)
                                        <option value="{{ $jdl->kd_jadwal }}">
                                            {{ $jdl->jadwal }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2 mt-3">
                                <strong>Bulan</strong>
                            </div>
                            <div class="col-md-10  mt-3">
                                <select name="bulan" class="form-control">
                                    <option value="01">Januari</option>
                                    <option value="02">Februari</option>
                                    <option value="03">Maret</option>
                                    <option value="04">April</option>
                                    <option value="05">Mei</option>
                                    <option value="06">Juni</option>
                                    <option value="07">Juli</option>
                                    <option value="08">Agustus</option>
                                    <option value="09">September</option>
                                    <option value="10">Oktober</option>
                                    <option value="11">November</option>
                                    <option value="12">Desember</option>
                                </select>
                            </div>
                            <div class="col-md-2 mt-3">
                                <strong>OPD</strong>
                            </div>
                            <div class="col-md-10 mt-3">
                                <select id="select_opd2" name="opd" class="form-control">
                                    <option value="">-- Pilih OPD --</option>
                                    @foreach ($d_opd as $value => $opd)
                                        <option value="{{ $opd->kd_opd }}">
                                            {{ $opd->nm_opd }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-12 text-right">
                                <button type="submit" class="btn btn-success mt-2 mb-3"><i
                                        class="fas fa-file-excel"></i>
                                    Cetak</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#select_opd').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#select_opd2').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
@endsection
