<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Bupati OPD</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="{{ public_path('images/logokab.png') }}" height="100">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 20pt; font-weight: bold;">DATA REALISASI PENERIMAAN SKPD PENGHASIL</div>
                <div style="font-size: 16pt; font-weight: bold;">PEMERINTAH KABUPATEN BOJONEGORO</div>
                <div style="font-size: 16pt; font-weight: bold;">
                    @foreach ($ref_opd as $ropd)
                        {{ $ropd->nm_opd }}
                    @endforeach
                </div>
                <div style="font-size: 12pt;">Tahun Anggaran 2025</div>
                <div style="font-size: 12pt;"> {{ \Carbon\Carbon::parse($daritanggal)->translatedFormat('d F Y') }}
                    Sampai
                    Tanggal
                    {{ \Carbon\Carbon::parse($sampaitanggal)->translatedFormat('d F Y') }}
                </div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th>KODE</th>
                <th>URAIAN</th>
                <th>TARGET (Rp)</th>
                <th>REALISASI (Rp)</th>
                <th>CAPAIAN (%)</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rows as $row)
                <tr @if ($row['bold']) style="font-weight:bold;" @endif>
                    <td>{{ $row['kode'] }}</td>
                    <td>{{ $row['nama'] }}</td>
                    <td class="right">
                        {{ $row['target'] > 0 ? number_format($row['target'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row['total'] > 0 ? number_format($row['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row['capaian']) ? number_format($row['capaian'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
            @foreach ($rows2 as $row2)
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right text-bold">
                        <b>{{ $row2['target'] > 0 ? number_format($row2['target'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ $row2['total'] > 0 ? number_format($row2['total'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ isset($row2['capaian']) ? number_format($row2['capaian'], 2, ',', '.') . '%' : '' }}</b>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <br><br>
    <table width="100%" style="border: none; margin-top: 40px;">
        <tr>
            <td style="border: none; width: 60%;"></td>
            <td style="border: none; text-align: center;">
                Bojonegoro, {{ \Carbon\Carbon::now()->translatedFormat('d F Y') }}<br>
                KEPALA BADAN PENDAPATAN DAERAH,<br>
                KABUPATEN BOJONEGORO<br><br><br><br>
                <u><b>YUSNITA LIASARI, ST, M.Si</b></u><br>
                Pembina Utama Muda
                <br>
                NIP. 19721127 199803 1 006
            </td>
        </tr>
    </table>
</body>

</html>
