<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Bupati</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="{{ public_path('images/logokab.png') }}" height="80">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 20pt; font-weight: bold;">DAFTAR REKAPITULASI PENERIMAAN PENDAPATAN DAERAH</div>
                <div style="font-size: 18pt; font-weight: bold;">PEMERINTAH KABUPATEN BOJONEGORO</div>
                <div style="font-size: 16pt;">Tahun Anggaran 2025</div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th rowspan="2">KODE</th>
                <th rowspan="2">URAIAN</th>
                <th colspan="2">TARGET (Rp)</th>
                <th rowspan="2">REALISASI (Rp)</th>
                <th colspan="2">CAPAIAN (%)</th>
            </tr>
            <tr>
                <th>TARGET INDUK (Rp)</th>
                <th>TARGET PERUBAHAN (Rp)</th>
                <th>CAPAIAN INDUK(%)</th>
                <th>CAPAIAN INDUK(%)</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rows1 as $row1)
                <tr @if ($row1['bold']) style="font-weight:bold;" @endif>
                    <td>{{ $row1['kode'] }}</td>
                    <td>{{ $row1['nama'] }}</td>
                    <td class="right">
                        {{ $row1['targetinduk'] > 0 ? number_format($row1['targetinduk'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row1['targetperubahan'] > 0 ? number_format($row1['targetperubahan'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row1['total'] > 0 ? number_format($row1['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row1['capaianinduk']) ? number_format($row1['capaianinduk'], 2, ',', '.') . '%' : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row1['capaianperubahan']) ? number_format($row1['capaianperubahan'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
            @foreach ($rows2 as $row2)
                <tr @if ($row2['bold']) style="font-weight:bold;" @endif>
                    <td>{{ $row2['kode'] }}</td>
                    <td>{{ $row2['nama'] }}</td>
                    <td class="right">
                        {{ $row1['targetinduk'] > 0 ? number_format($row1['targetinduk'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row1['targetperubahan'] > 0 ? number_format($row1['targetperubahan'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row1['total'] > 0 ? number_format($row1['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row1['capaianinduk']) ? number_format($row1['capaianinduk'], 2, ',', '.') . '%' : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row1['capaianperubahan']) ? number_format($row1['capaianperubahan'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
            @foreach ($rows3 as $row3)
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right">
                        {{ $row3['targetinduk'] > 0 ? number_format($row3['targetinduk'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row3['targetperubahan'] > 0 ? number_format($row3['targetperubahan'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row3['capaianinduk']) ? number_format($row3['capaianinduk'], 2, ',', '.') . '%' : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row3['capaianperubahan']) ? number_format($row3['capaianperubahan'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <br><br>
    <table width="100%" style="border: none; margin-top: 40px;">
        <tr>
            <td style="border: none; width: 60%;"></td>
            <td style="border: none; text-align: center;">
                Bojonegoro, {{ \Carbon\Carbon::now()->translatedFormat('d F Y') }}<br>
                KEPALA BADAN PENDAPATAN DAERAH,<br>
                KABUPATEN BOJONEGORO<br><br><br><br>
                <u><b>YUSNITA LIASARI, ST, M.Si</b></u><br>
                Pembina Utama Muda
                <br>
                NIP. 19721127 199803 1 006
            </td>
        </tr>
    </table>
</body>

</html>
