<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
use Illuminate\Support\Arr;
use Illuminate\View\View;
use Illuminate\Http\RedirectResponse;
use Illuminate\Pagination\LengthAwarePaginator;

class Refrek6Controller extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request): View
    {
        $rek1 = DB::table('ref_rek1')->get();
        $rek2 = DB::table('ref_rek2')->get();
        $rek3 = DB::table('ref_rek3')->get();
        $rek4 = DB::table('ref_rek4')->get();
        $rek5 = DB::table('ref_rek5')->get();
        $rek6 = DB::table('ref_rek6')->get();

        $finalData = [];

        foreach ($rek1 as $r1) {
            $finalData[] = [
                'kode' => $r1->kd_rek1,
                'nama' => $r1->nm_rek1,
            ];

            foreach ($rek2 as $r2) {
                if ($r2->kd_rek1 == $r1->kd_rek1) {
                    $finalData[] = [
                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                        'nama' => $r2->nm_rek2,
                    ];

                    foreach ($rek3 as $r3) {
                        if ($r3->kd_rek1 == $r1->kd_rek1 && $r3->kd_rek2 == $r2->kd_rek2) {
                            $finalData[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                            ];

                            foreach ($rek4 as $r4) {
                                if (
                                    $r4->kd_rek1 == $r1->kd_rek1 &&
                                    $r4->kd_rek2 == $r2->kd_rek2 &&
                                    $r4->kd_rek3 == $r3->kd_rek3
                                ) {
                                    $finalData[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                        'nama' => $r4->nm_rek4,
                                    ];

                                    foreach ($rek5 as $r5) {
                                        if (
                                            $r5->kd_rek1 == $r1->kd_rek1 &&
                                            $r5->kd_rek2 == $r2->kd_rek2 &&
                                            $r5->kd_rek3 == $r3->kd_rek3 &&
                                            $r5->kd_rek4 == $r4->kd_rek4
                                        ) {
                                            $finalData[] = [
                                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                                'nama' => $r5->nm_rek5,
                                            ];

                                            foreach ($rek6 as $r6) {
                                                if (
                                                    $r6->kd_rek1 == $r1->kd_rek1 &&
                                                    $r6->kd_rek2 == $r2->kd_rek2 &&
                                                    $r6->kd_rek3 == $r3->kd_rek3 &&
                                                    $r6->kd_rek4 == $r4->kd_rek4 &&
                                                    $r6->kd_rek5 == $r5->kd_rek5
                                                ) {
                                                    $finalData[] = [
                                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                                        'nama' => $r6->nm_rek6,
                                                    ];
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        // Manual Pagination
        $page = $request->input('page', 1);
        $perPage = 10;
        $offset = ($page - 1) * $perPage;

        $paginated = new LengthAwarePaginator(
            array_slice($finalData, $offset, $perPage),
            count($finalData),
            $perPage,
            $page,
            ['path' => url()->current()]
        );

        return view('refrek6.index', [
            'data' => $paginated
        ]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(): View {}
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request): RedirectResponse {}

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id): View {}

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id): View {}

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id): RedirectResponse {}

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id): RedirectResponse {}
}
