<?php

namespace App\Http\Controllers;

use App\Models\Pendapatan;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PendapatanController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('permission:pendapatan-list|pendapatan-create|pendapatan-edit|pendapatan-delete', ['only' => ['index', 'store']]);
    //     $this->middleware('permission:pendapatan-create', ['only' => ['create', 'store']]);
    //     $this->middleware('permission:pendapatan-edit', ['only' => ['edit', 'update']]);
    //     $this->middleware('permission:pendapatan-delete', ['only' => ['destroy']]);
    // }
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request): View
    {
        $data = DB::table('tbl_pendapatan')
            ->select(
                'tbl_pendapatan.id_transaksi',
                'tbl_pendapatan.tahun',
                'tbl_pendapatan.tgl_transaksi',
                'ref_opd.nm_opd',
                DB::raw("CONCAT(
                tbl_pendapatan.kd_rek1, '.',
                tbl_pendapatan.kd_rek2, '.',
                tbl_pendapatan.kd_rek3, '.',
                tbl_pendapatan.kd_rek4, '.',
                tbl_pendapatan.kd_rek5, '.',
                tbl_pendapatan.kd_rek6) AS kd_rekening"),
                'ref_rek6.nm_rek6',
                'tbl_pendapatan.keterangan',
                'tbl_pendapatan.nilai'
            )
            ->join('ref_opd', 'ref_opd.kd_opd', '=', 'tbl_pendapatan.kd_opd')
            ->join(
                'ref_rek6',
                function ($join) {
                    $join->on(
                        'ref_rek6.kd_rek1',
                        '=',
                        'tbl_pendapatan.kd_rek1'
                    )
                        ->on(
                            'ref_rek6.kd_rek2',
                            '=',
                            'tbl_pendapatan.kd_rek2'
                        )
                        ->on(
                            'ref_rek6.kd_rek3',
                            '=',
                            'tbl_pendapatan.kd_rek3'
                        )->on(
                            'ref_rek6.kd_rek4',
                            '=',
                            'tbl_pendapatan.kd_rek4',
                        )->on(
                            'ref_rek6.kd_rek5',
                            '=',
                            'tbl_pendapatan.kd_rek5'
                        )->on(
                            'ref_rek6.kd_rek6',
                            '=',
                            'tbl_pendapatan.kd_rek6'
                        );
                }
            )
            ->orderBy('tgl_transaksi')
            ->get();
        // $transaksi = $data->groupBy('tgl_transaksi')->map(function ($items) {
        //     return $items->groupBy('kd_rekening');
        // });

        // $totals = $data->groupBy('tgl_transaksi')->map(function ($items) {
        //     return $items->sum('nilai');
        // });
        return view('pendapatan.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $rekening = DB::select("SELECT * FROM ref_rek6");
        $d_opd = DB::select("SELECT * FROM ref_opd");
        return view('pendapatan.create', compact('rekening', 'd_opd'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'opd' => 'required',
            'tgl_transaksi' => 'required',
            'rekening' => 'required',
            'keterangan' => 'required'
        ]);
        $rekening = $request->input('rekening');
        $kd_rek = explode('.', $rekening);
        $kd_rek1 = $kd_rek[0];
        $kd_rek2 = $kd_rek[1];
        $kd_rek3 = $kd_rek[2];
        $kd_rek4 = $kd_rek[3];
        $kd_rek5 = $kd_rek[4];
        $kd_rek6 = $kd_rek[5];

        $input = [
            'tahun' => $request->input('tahun'),
            'kd_opd' => $request->input('opd'),
            'tgl_transaksi' => $request->input('tgl_transaksi'),
            'kd_rek1' => $kd_rek1,
            'kd_rek2' => $kd_rek2,
            'kd_rek3' => $kd_rek3,
            'kd_rek4' => $kd_rek4,
            'kd_rek5' => $kd_rek5,
            'kd_rek6' => $kd_rek6,
            'keterangan' => $request->input('keterangan'),
            'nilai' => $request->input('nilai'),
            'tgl_input' => now()
        ];
        DB::table('tbl_pendapatan')->insert($input);
        return redirect()->route('pendapatan.index')
            ->with('success', 'Pendapatan Berhasil Diinput');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $pendapatan =  DB::table('tbl_pendapatan')
            ->select(
                'tbl_pendapatan.id_transaksi',
                'tbl_pendapatan.tahun',
                'tbl_pendapatan.tgl_transaksi',
                'tbl_pendapatan.kd_opd',
                'ref_opd.nm_opd',
                DB::raw("CONCAT(
                tbl_pendapatan.kd_rek1, '.',
                tbl_pendapatan.kd_rek2, '.',
                tbl_pendapatan.kd_rek3, '.',
                tbl_pendapatan.kd_rek4, '.',
                tbl_pendapatan.kd_rek5, '.',
                tbl_pendapatan.kd_rek6) AS kd_rekening"),
                'ref_rek6.nm_rek6',
                'tbl_pendapatan.keterangan',
                'tbl_pendapatan.nilai'
            )
            ->join('ref_opd', 'ref_opd.kd_opd', '=', 'tbl_pendapatan.kd_opd')
            ->join(
                'ref_rek6',
                function ($join) {
                    $join->on(
                        'ref_rek6.kd_rek1',
                        '=',
                        'tbl_pendapatan.kd_rek1'
                    )
                        ->on(
                            'ref_rek6.kd_rek2',
                            '=',
                            'tbl_pendapatan.kd_rek2'
                        )
                        ->on(
                            'ref_rek6.kd_rek3',
                            '=',
                            'tbl_pendapatan.kd_rek3'
                        )->on(
                            'ref_rek6.kd_rek4',
                            '=',
                            'tbl_pendapatan.kd_rek4',
                        )->on(
                            'ref_rek6.kd_rek5',
                            '=',
                            'tbl_pendapatan.kd_rek5'
                        )->on(
                            'ref_rek6.kd_rek6',
                            '=',
                            'tbl_pendapatan.kd_rek6'
                        );
                }
            )->where('id_transaksi', $id)->first();
        $rekening = DB::select("SELECT * FROM ref_rek6");
        $d_opd = DB::select("SELECT * FROM ref_opd");
        return view('pendapatan.edit', compact('pendapatan', 'rekening', 'd_opd'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, int $id)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'opd' => 'required',
            'tgl_transaksi' => 'required',
            'rekening' => 'required',
            'keterangan' => 'required'
        ]);
        $rekening = $request->input('rekening');
        $kd_rek = explode('.', $rekening);
        $kd_rek1 = $kd_rek[0];
        $kd_rek2 = $kd_rek[1];
        $kd_rek3 = $kd_rek[2];
        $kd_rek4 = $kd_rek[3];
        $kd_rek5 = $kd_rek[4];
        $kd_rek6 = $kd_rek[5];

        $input = [
            'tahun' => $request->input('tahun'),
            'kd_opd' => $request->input('opd'),
            'tgl_transaksi' => $request->input('tgl_transaksi'),
            'kd_rek1' => $kd_rek1,
            'kd_rek2' => $kd_rek2,
            'kd_rek3' => $kd_rek3,
            'kd_rek4' => $kd_rek4,
            'kd_rek5' => $kd_rek5,
            'kd_rek6' => $kd_rek6,
            'keterangan' => $request->input('keterangan'),
            'nilai' => $request->input('nilai'),
            'tgl_input' => now()
        ];
        DB::table('tbl_pendapatan')->where('id_transaksi', $id)->update($input);
        return redirect()->route('pendapatan.index')
            ->with('success', 'Pendapatan Berhasil Diedit');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        DB::table('tbl_pendapatan')->where('id_transaksi', $id)->delete();
        return redirect()->route('pendapatan.index')
            ->with('success', 'Pendapatan Berhasil Dihapus');
    }
}
