<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Support\Facades\DB;

class ExportExcelController extends Controller
{
    public function exportExcel()
    {
        $transaksi = DB::table('tbl_pendapatan')
            ->select(
                'kd_rek1',
                'kd_rek2',
                'kd_rek3',
                'kd_rek4',
                'kd_rek5',
                'kd_rek6',
                DB::raw('SUM(nilai) as total')
            )
            ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
            ->get();

        $targets = DB::table('tbl_target')
            ->select(
                'kd_rek1',
                'kd_rek2',
                'kd_rek3',
                'kd_rek4',
                'kd_rek5',
                'kd_rek6',
                DB::raw('SUM(nilai) as total')
            )
            ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
            ->get();

        $rek1 = DB::table('ref_rek1')->get();
        $rek2 = DB::table('ref_rek2')->get();
        $rek3 = DB::table('ref_rek3')->get();
        $rek4 = DB::table('ref_rek4')->get();
        $rek5 = DB::table('ref_rek5')->get();
        $rek6 = DB::table('ref_rek6')->get();

        foreach ($rek1 as $r1) {
            foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                    foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                        foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                            foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                $kode = "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}";
                                $nama = $r6->nama_rek;

                                $total = $transaksi->firstWhere(function ($item) use ($r1, $r2, $r3, $r4, $r5, $r6) {
                                    return $item->kd_rek1 == $r1->kd_rek1 &&
                                        $item->kd_rek2 == $r2->kd_rek2 &&
                                        $item->kd_rek3 == $r3->kd_rek3 &&
                                        $item->kd_rek4 == $r4->kd_rek4 &&
                                        $item->kd_rek5 == $r5->kd_rek5 &&
                                        $item->kd_rek6 == $r6->kd_rek6;
                                })?->total ?? 0;

                                $target = $targets->firstWhere(function ($item) use ($r1, $r2, $r3, $r4, $r5, $r6) {
                                    return $item->kd_rek1 == $r1->kd_rek1 &&
                                        $item->kd_rek2 == $r2->kd_rek2 &&
                                        $item->kd_rek3 == $r3->kd_rek3 &&
                                        $item->kd_rek4 == $r4->kd_rek4 &&
                                        $item->kd_rek5 == $r5->kd_rek5 &&
                                        $item->kd_rek6 == $r6->kd_rek6;
                                })?->total ?? 0;

                                if ($total > 0 || $target > 0) {
                                    $capaian = $target > 0 ? ($total / $target) * 100 : 0;
                                    $rows[] = compact('kode', 'nama', 'target', 'total', 'capaian');
                                }
                            }
                        }
                    }
                }
            }
        }

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Header
        $sheet->setCellValue('A1', 'Kode Rekening');
        $sheet->setCellValue('B1', 'Uraian');
        $sheet->setCellValue('C1', 'Target');
        $sheet->setCellValue('D1', 'Realisasi');
        $sheet->setCellValue('E1', '% Capaian');

        // Data dummy, kamu bisa load dari database
        $data = [];

        $row = 2;
        foreach ($data as $item) {
            $sheet->setCellValue("A$row", $item['kode']);
            $sheet->setCellValue("B$row", $item['uraian']);
            $sheet->setCellValue("C$row", $item['target']);
            $sheet->setCellValue("D$row", $item['realisasi']);

            $persen = $item['target'] > 0
                ? round(($item['realisasi'] / $item['target']) * 100, 2)
                : 0;

            $sheet->setCellValue("E$row", $persen . '%');
            $row++;
        }

        // Simpan ke file sementara
        $filename = 'laporan.xlsx';
        $writer = new Xlsx($spreadsheet);
        $tempPath = storage_path("app/public/{$filename}");
        $writer->save($tempPath);

        // Unduh file
        return response()->download($tempPath)->deleteFileAfterSend(true);
    }
}
