<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Gubernur</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <td width="15%" align="left" style="border: none;">
            <img src="<?php echo e(public_path('images/logokab.png')); ?>" height="80">
        </td>
        <td width="85%" align="center" style="border: none;">
            <div style="font-size: 18pt; font-weight: bold;">REKAPITULASI LAPORAN REALISASI PENERIMAAN PENDAPATAN DAERAH
                KABUPATEN BOJONEGORO</div>
            <div style="font-size: 12pt;">KEADAAN S/D
                <?php echo e(strtoupper(\Carbon\Carbon::parse($end)->translatedFormat('d F Y'))); ?>

            </div>
        </td>

    </table>
    <table border="1" cellspacing="0" cellpadding="5" style="font-size: 12px; width: 100%;">
        <thead style="text-align: center; background-color: #e5e5e5;">
            <tr class="text-center">
                <th rowspan="2">KODE REKENING</th>
                <th rowspan="2">URAIAN PENERIMAAN</th>
                <th rowspan="2">TARGET<br>APBD TAHUN </th>
                <th colspan="3">REALISASI REKENING</th>
                <th rowspan="2">APBD<br>%</th>
            </tr>
            <tr class="text-center">
                <th>S/D BULAN LALU<br>S/D <?php echo e(strtoupper(\Carbon\Carbon::parse($start)->translatedFormat('d F Y'))); ?>

                </th>
                <th>BULAN INI<br>1 S/D <?php echo e(strtoupper(\Carbon\Carbon::parse($end)->translatedFormat('d F Y'))); ?></th>
                <th>S/D BULAN INI<br>S/D <?php echo e(strtoupper(\Carbon\Carbon::parse($end)->translatedFormat('d F Y'))); ?>

                </th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr <?php if($row['bold']): ?> style="font-weight:bold;" <?php endif; ?>>
                    <td><?php echo e($row['kode']); ?></td>
                    <td><?php echo e($row['nama']); ?></td>
                    <td class="right">
                        <?php echo e($row['target'] > 0 ? number_format($row['target'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row['totalbulanlalu'] > 0 ? number_format($row['totalbulanlalu'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row['totalbulanini'] > 0 ? number_format($row['totalbulanini'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row['total'] > 0 ? number_format($row['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row['capaian']) ? number_format($row['capaian'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $rows2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr <?php if($row2['bold']): ?> style="font-weight:bold;" <?php endif; ?>>
                    <td><?php echo e($row2['kode']); ?></td>
                    <td><?php echo e($row2['nama']); ?></td>
                    <td class="right">
                        <?php echo e($row2['target'] > 0 ? number_format($row2['target'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row2['totalbulanlalu'] > 0 ? number_format($row2['totalbulanlalu'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row2['totalbulanini'] > 0 ? number_format($row2['totalbulanini'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row2['total'] > 0 ? number_format($row2['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row2['capaian']) ? number_format($row2['capaian'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $rows3; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row3): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right text-bold">
                        <b><?php echo e($row3['target'] > 0 ? number_format($row3['target'], 2, ',', '.') : ''); ?></b>
                    </td>
                    <td class="right text-bold">
                        <b><?php echo e($row3['totalbulanlalu'] > 0 ? number_format($row3['totalbulanlalu'], 2, ',', '.') : ''); ?></b>
                    </td>
                    <td class="right text-bold">
                        <b><?php echo e($row3['totalbulanini'] > 0 ? number_format($row3['totalbulanini'], 2, ',', '.') : ''); ?></b>
                    </td>
                    <td class="right text-bold">
                        <b><?php echo e($row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : ''); ?></b>
                    </td>
                    <td class="right text-bold">
                        <b><?php echo e(isset($row3['capaian']) ? number_format($row3['capaian'], 2, ',', '.') . '%' : ''); ?></b>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/laporan/laporan_gubernur_pdf.blade.php ENDPATH**/ ?>