<?php $__env->startSection('content_app'); ?>
    <div class="card shadow">
        <div class="card-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <h2 class="m-0 font-weight-bold text-dark">Tambah Target Pendapatan</h2>
                    </div>
                    <div class="col-md-6 text-right">
                        <a href="<?php echo e(route('target.index')); ?>" class="btn btn-danger rounded text-right"><i
                                class="fas fa-backward"></i></a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('target.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-md-2">
                        <strong>Tahun</strong>
                    </div>
                    <div class="col-md-10">
                        <select name="tahun" class="form-control">
                            <option value="2025">2025</option>
                        </select>
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Jadwal</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <select id="jadwal" name="jadwal" class="form-control">
                            <option value="">-- Pilih Jadwal --</option>
                            <?php $__currentLoopData = $jadwal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $jdl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($jdl->kd_jadwal); ?>">
                                    <?php echo e($jdl->jadwal); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>OPD</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <select id="select_opd" name="opd" class="form-control">
                            <option value="">-- Pilih OPD --</option>
                            <?php $__currentLoopData = $d_opd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $opd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($opd->kd_opd); ?>">
                                    <?php echo e($opd->nm_opd); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Rekening</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <select id="select_rekening" name="rekening" class="form-control">
                            <option value="">-- Pilih Rekening --</option>
                            <?php $__currentLoopData = $rekening; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $rek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option
                                    value="<?php echo e($rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6); ?>">
                                    <?php echo e($rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6); ?>

                                    <?php echo e($rek->nm_rek6); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Keterangan</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <input type="text" name="keterangan" placeholder="Keterangan" class="form-control">
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Nilai</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <input type="text" id="nilai_format" placeholder="Nilai" class="form-control"
                            oninput="formatRibuan(this)">
                        <input type="hidden" id="nilai" name="nilai">
                    </div>
                    <div class="col-md-12 text-right">
                        <button type="submit" class="btn btn-primary mt-2 mb-3"><i class="fas fa-sd-card"></i>
                            Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#select_rekening').select2({
                placeholder: "Cari Rekening",
                allowClear: true
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#select_opd').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
    <script>
        function formatRibuan(input) {
            // Simpan posisi kursor
            const cursorPos = input.selectionStart;

            // Ambil hanya angka dan koma (hanya satu koma diizinkan)
            let raw = input.value.replace(/[^0-9,]/g, '');

            // Pisahkan bagian ribuan dan desimal
            let parts = raw.split(',');

            let ribuan = parts[0];
            let desimal = parts[1] !== undefined ? parts[1] : '';

            // Format angka ribuan
            let formattedRibuan = ribuan.replace(/\B(?=(\d{3})+(?!\d))/g, '.');

            // Gabungkan kembali
            let formatted = desimal !== '' ? `${formattedRibuan},${desimal}` : formattedRibuan;

            input.value = formatted;

            // Simpan dalam hidden field sebagai format numerik (1200,50 jadi 1200.50)
            let numeric = ribuan.replace(/\./g, '') + (desimal !== '' ? '.' + desimal : '');
            document.getElementById('nilai').value = numeric;

            // Atur ulang posisi kursor agar nyaman
            input.setSelectionRange(cursorPos, cursorPos);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/target/create.blade.php ENDPATH**/ ?>