<?php $__env->startSection('content_app'); ?>
    <div class="card shadow">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h2 class="m-0 font-weight-bold text-dark">Edit Target Pendapatan</h2>
                </div>
                <div class="col-md-6 text-right">
                    <a href="<?php echo e(route('target.index')); ?>" class="btn btn-danger rounded text-right"><i
                            class="fas fa-backward"></i></a>
                </div>
            </div>
        </div>
        <?php if(count($errors) > 0): ?>
            <div class="alert alert-danger">
                <strong>Whoops!</strong> There were some problems with your input.<br><br>
                <ul>
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>
        <div class="card-body">
            <form method="POST" action="<?php echo e(route('target.update', $target->id_target)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <strong>Tahun:</strong>
                            <select name="tahun" class="form-control">
                                <option value="<?php echo e($target->tahun); ?>"><?php echo e($target->tahun); ?></option>
                            </select>
                        </div>
                        <div class="form-group">
                            <strong>JADWAL</strong>
                            <select id="jadwal" name="jadwal" class="form-control">
                                <option value="<?php echo e($target->kd_jadwal); ?>"><?php echo e($target->jadwal); ?>

                                </option>
                                <?php $__currentLoopData = $jadwal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $jdl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($jdl->kd_jadwal); ?>">
                                        <?php echo e($jdl->jadwal); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <strong>OPD:</strong>
                            <select id="select_opd" name="opd" class="form-control">
                                <option value="<?php echo e($target->kd_opd); ?>"><?php echo e($target->nm_opd); ?>

                                </option>
                                <?php $__currentLoopData = $d_opd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $opd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($opd->kd_opd); ?>">
                                        <?php echo e($opd->nm_opd); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Rekening:</strong>
                            <select id="select_rekening" name="rekening" class="form-control">
                                <option value="<?php echo e($target->kd_rekening); ?>">
                                    <?php echo e($target->kd_rekening . ' ' . $target->nm_rek6); ?>

                                </option>
                                <?php $__currentLoopData = $rekening; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value => $rek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option
                                        value="<?php echo e($rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6); ?>">
                                        <?php echo e($rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6); ?>

                                        <?php echo e($rek->nm_rek6); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Keterangan</strong>
                            <input type="text" name="keterangan" placeholder="Keterangan" class="form-control"
                                value="<?php echo e($target->keterangan); ?>">
                        </div>
                    </div>

                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Nilai:</strong>
                            <input type="text" name="nilai" placeholder="Nilai" class="form-control"
                                oninput="formatRibuan(this)" value="<?php echo e($target->nilai); ?>">
                            <input type="hidden" id="nilai" name="nilai">
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 text-right">
                        <button type="submit" class="btn btn-primary btn-md mt-2 mb-3"><i class="fas fa-sd-card"></i>
                            Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#select_rekening').select2({
                placeholder: "Cari Rekening",
                allowClear: true
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#select_opd').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
    <script>
        function formatRibuan(el) {
            // Hapus semua karakter selain angka
            let raw = el.value.replace(/[^0-9]/g, '');

            // Simpan ke input hidden (tanpa format)
            document.getElementById('nilai').value = raw;

            // Format tampilan input
            el.value = raw.replace(/\B(?=(\d{3})+(?!\d))/g, ',');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/target/edit.blade.php ENDPATH**/ ?>