<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Bupati OPD</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="<?php echo e(public_path('images/logokab.png')); ?>" height="100">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 20pt; font-weight: bold;">DATA REALISASI PENERIMAAN SKPD PENGHASIL</div>
                <div style="font-size: 16pt; font-weight: bold;">PEMERINTAH KABUPATEN BOJONEGORO</div>
                <div style="font-size: 16pt; font-weight: bold;">
                    <?php $__currentLoopData = $ref_opd; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ropd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($ropd->nm_opd); ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div style="font-size: 12pt;">Tahun Anggaran 2025</div>
                <div style="font-size: 12pt;"> <?php echo e(\Carbon\Carbon::parse($daritanggal)->translatedFormat('d F Y')); ?>

                    Sampai
                    Tanggal
                    <?php echo e(\Carbon\Carbon::parse($sampaitanggal)->translatedFormat('d F Y')); ?>

                </div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th>KODE</th>
                <th>URAIAN</th>
                <th>TARGET (Rp)</th>
                <th>REALISASI (Rp)</th>
                <th>CAPAIAN (%)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr <?php if($row['bold']): ?> style="font-weight:bold;" <?php endif; ?>>
                    <td><?php echo e($row['kode']); ?></td>
                    <td><?php echo e($row['nama']); ?></td>
                    <td class="right">
                        <?php echo e($row['target'] > 0 ? number_format($row['target'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e($row['total'] > 0 ? number_format($row['total'], 2, ',', '.') : ''); ?>

                    </td>
                    <td class="right">
                        <?php echo e(isset($row['capaian']) ? number_format($row['capaian'], 2, ',', '.') . '%' : ''); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $rows2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right text-bold">
                        <b><?php echo e($row2['target'] > 0 ? number_format($row2['target'], 2, ',', '.') : ''); ?></b>
                    </td>
                    <td class="right text-bold">
                        <b><?php echo e($row2['total'] > 0 ? number_format($row2['total'], 2, ',', '.') : ''); ?></b>
                    </td>
                    <td class="right text-bold">
                        <b><?php echo e(isset($row2['capaian']) ? number_format($row2['capaian'], 2, ',', '.') . '%' : ''); ?></b>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <br><br>
    <table width="100%" style="border: none; margin-top: 40px;">
        <tr>
            <td style="border: none; width: 60%;"></td>
            <td style="border: none; text-align: center;">
                Bojonegoro, <?php echo e(\Carbon\Carbon::now()->translatedFormat('d F Y')); ?><br>
                KEPALA BADAN PENDAPATAN DAERAH,<br>
                KABUPATEN BOJONEGORO<br><br><br><br>
                <u><b>YUSNITA LIASARI, ST, M.Si</b></u><br>
                Pembina Utama Muda
                <br>
                NIP. 19721127 199803 1 006
            </td>
        </tr>
    </table>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\silapad_app\resources\views/laporan/laporan_bupati_opd_pdf.blade.php ENDPATH**/ ?>