@extends('layouts.default')

@section('content_app')
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <div class="container-fluid">
                <div class="pull-left">
                    <h2 class="m-0 font-weight-bold text-dark">Halaman Rekening</h2>
                </div>
                <div class="row">
                    <div class="col-lg-12 margin-tb">
                    </div>
                </div>

                @session('success')
                    <div class="alert alert-success" role="alert">
                        {{ $value }}
                    </div>
                @endsession
                <div class="card-body">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th style="width: 10%">Kode Rekening</th>
                                <th style="width: 60%">Nama Rekening</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($data as $item)
                                <tr>
                                    <td>{{ $item['kode'] }}</td>
                                    <td>{{ $item['nama'] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                {!! $data->links('pagination::bootstrap-5') !!}
            </div>
        </div>
    </div>
@endsection
