@extends('layouts.default')

@section('content_app')
    <div class="card shadow">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <h2 class="m-0 font-weight-bold text-dark">Edit B IX</h2>
                </div>
                <div class="col-md-6 text-right">
                    <a href="{{ route('pendapatan.index') }}" class="btn btn-danger rounded text-right"><i
                            class="fas fa-backward"></i></a>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <strong>Whoops!</strong> There were some problems with your input.<br><br>
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form method="POST" action="{{ route('pendapatan.update', $pendapatan->id_transaksi) }}">
                @csrf
                @method('PUT')
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <strong>Tahun:</strong>
                            <select name="tahun" class="form-control">
                                <option value="{{ $pendapatan->tahun }}">{{ $pendapatan->tahun }}</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <strong>OPD:</strong>
                            <select id="select_opd" name="opd" class="form-control">
                                <option value="{{ $pendapatan->kd_opd }}">{{ $pendapatan->nm_opd }}
                                </option>
                                @foreach ($d_opd as $value => $opd)
                                    <option value="{{ $opd->kd_opd }}">
                                        {{ $opd->nm_opd }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Tanggal:</strong>
                            <input type="date" name="tgl_transaksi" placeholder="Name" class="form-control"
                                value="{{ $pendapatan->tgl_transaksi }}">
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Rekening:</strong>
                            <select id="select_rekening" name="rekening" class="form-control">
                                <option value="{{ $pendapatan->kd_rekening }}">
                                    {{ $pendapatan->kd_rekening . ' ' . $pendapatan->nm_rek6 }}
                                </option>
                                @foreach ($rekening as $value => $rek)
                                    <option
                                        value="{{ $rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6 }}">
                                        {{ $rek->kd_rek1 . '.' . $rek->kd_rek2 . '.' . $rek->kd_rek3 . '.' . $rek->kd_rek4 . '.' . $rek->kd_rek5 . '.' . $rek->kd_rek6 }}
                                        {{ $rek->nm_rek6 }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Keterangan:</strong>
                            <input type="text" name="keterangan" placeholder="Keterangan" class="form-control"
                                value="{{ $pendapatan->keterangan }}">
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12">
                        <div class="form-group">
                            <strong>Nilai:</strong>
                            <input type="number" name="nilai" placeholder="Nilai" class="form-control"
                                value="{{ $pendapatan->nilai }}">
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-12 col-md-12 text-right">
                        <button type="submit" class="btn btn-primary btn-md mt-2 mb-3"><i class="fas fa-sd-card"></i>
                            Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#select_rekening').select2({
                placeholder: "Cari Rekening",
                allowClear: true
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            $('#select_opd').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
@endsection
