@extends('layouts.default')

@section('content_app')
    <div class="card shadow">
        <div class="card-header">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-6">
                        <h2 class="m-0 font-weight-bold text-dark">Cetak Rincian Pendapatan</h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <form method="POST" action="{{ route('exportExcelRincianPendapatan') }}">
                @csrf
                <div class="row">
                    <div class="col-md-2">
                        <strong>Tahun</strong>
                    </div>
                    <div class="col-md-10">
                        <select name="tahun" class="form-control">
                            <option value="2025">2025</option>
                            <option value="2026">2026</option>
                            <option value="2027">2027</option>
                        </select>
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Dari Tanggal</strong>
                    </div>
                    <div class="col-md-10  mt-3">
                        <input type="date" name="dari_tanggal" placeholder="Name" class="form-control">
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>Sampai Tanggal</strong>
                    </div>
                    <div class="col-md-10  mt-3">
                        <input type="date" name="sampai_tanggal" placeholder="Name" class="form-control">
                    </div>
                    <div class="col-md-2 mt-3">
                        <strong>OPD</strong>
                    </div>
                    <div class="col-md-10 mt-3">
                        <select id="select_opd" name="opd" class="form-control">
                            <option value="">-- Pilih OPD --</option>
                            @foreach ($d_opd as $value => $opd)
                                <option value="{{ $opd->kd_opd }}">
                                    {{ $opd->nm_opd }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-12 text-right">
                        <button type="submit" class="btn btn-success mt-2 mb-3"><i class="fas fa-file-excel"></i>
                            Cetak</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#select_opd').select2({
                placeholder: "Cari OPD",
                allowClear: true
            });
        });
    </script>
@endsection
