<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Rincian Pendapatan</title>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="{{ public_path('images/logokab.png') }}" height="80">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 24pt; font-weight: bold;">LAPORAN RINCIAN PENDAPATAN</div>
                <div style="font-size: 12pt;">MENURUT TANGGAL, OPD, KODE REKENING DAN RINCIAN PENDAPATAN</div>
                <div style="font-size: 12pt;">Periode
                    {{ \Carbon\Carbon::parse($daritanggal)->translatedFormat('d F Y') }}
                    Sampai
                    {{ \Carbon\Carbon::parse($sampaitanggal)->translatedFormat('d F Y') }}
                </div>
            </td>
        </tr>
    </table>
    <table border="1" cellspacing="0" cellpadding="5" width="100%">
        <thead>
            <tr>
                <th>Tanggal</th>
                <th>OPD</th>
                <th>Rekening</th>
                <th>Keterangan</th>
                <th>Nominal</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($transaksis as $tanggal => $itemsByTanggal)
                @php
                    $groupedByOpd = $itemsByTanggal->groupBy('nm_opd');
                    $totalTanggal = 0;
                @endphp

                @foreach ($groupedByOpd as $opd => $itemsByOpd)
                    @php
                        $firstOpdRow = true;
                        $subtotalOpd = 0;
                    @endphp

                    @foreach ($itemsByOpd as $item)
                        <tr>
                            <td>{{ $firstOpdRow ? \Carbon\Carbon::parse($tanggal)->format('d/m/Y') : '' }}</td>
                            <td>{{ $firstOpdRow ? $opd : '' }}</td>
                            <td>{{ $item->rekening }}</td>
                            <td>{{ $item->keterangan }}</td>
                            <td style="text-align: right">{{ number_format($item->nilai, 2, ',', '.') }}</td>
                        </tr>
                        @php
                            $subtotalOpd += $item->nilai;
                            $totalTanggal += $item->nilai;
                            $firstOpdRow = false;
                        @endphp
                    @endforeach
                @endforeach
                {{-- Total per tanggal --}}
                <tr>
                    <td colspan="4" style="text-align: right"><strong>TOTAL TANGGAL
                            {{ \Carbon\Carbon::parse($tanggal)->format('d/m/Y') }}</strong></td>
                    <td style="text-align: right"><strong>{{ number_format($totalTanggal, 2, ',', '.') }}</strong></td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
