<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Laporan Bupati</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px;
            vertical-align: top;
        }

        th {
            background-color: #eee;
        }

        .bold {
            font-weight: bold;
        }

        .right {
            text-align: right;
        }
    </style>
</head>

<body>
    <table width="100%" style="border: none; margin-bottom: 10px;">
        <tr>
            <td width="15%" align="left" style="border: none;">
                <img src="{{ public_path('images/logokab.png') }}" height="80">
            </td>
            <td width="85%" align="center" style="border: none;">
                <div style="font-size: 24pt; font-weight: bold;">LAPORAN BUPATI</div>
                <div style="font-size: 20pt; font-weight: bold;">REKAPITULASI PENERIMAAN PENDAPATAN DAERAH</div>
                <div style="font-size: 18pt; font-weight: bold;">PEMERINTAH KABUPATEN BOJONEGORO</div>
                <div style="font-size: 16pt;">Periode Tahun 2025</div>
            </td>
        </tr>
    </table>
    <table>
        <thead>
            <tr>
                <th>KODE</th>
                <th>URAIAN</th>
                <th>TARGET (Rp)</th>
                <th>REALISASI (Rp)</th>
                <th>CAPAIAN (%)</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rows1 as $row1)
                <tr @if ($row['bold']) style="font-weight:bold;" @endif>
                    <td>{{ $row1['kode'] }}</td>
                    <td>{{ $row1['nama'] }}</td>
                    <td class="right">
                        {{ $row1['target'] > 0 ? number_format($row1['target'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row1['total'] > 0 ? number_format($row1['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row1['capaian']) ? number_format($row1['capaian'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
            @foreach ($rows2 as $row2)
                <tr @if ($row['bold']) style="font-weight:bold;" @endif>
                    <td>{{ $row2['kode'] }}</td>
                    <td>{{ $row2['nama'] }}</td>
                    <td class="right">
                        {{ $row2['target'] > 0 ? number_format($row2['target'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ $row2['total'] > 0 ? number_format($row2['total'], 2, ',', '.') : '' }}
                    </td>
                    <td class="right">
                        {{ isset($row2['capaian']) ? number_format($row2['capaian'], 2, ',', '.') . '%' : '' }}
                    </td>
                </tr>
            @endforeach
            @foreach ($rows3 as $row3)
                <tr>
                    <td colspan="2" class="text-bold" style="text-align: center"><b>Total Pendapatan</b></td>
                    <td class="right text-bold">
                        <b>{{ $row3['target'] > 0 ? number_format($row3['target'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ $row3['total'] > 0 ? number_format($row3['total'], 2, ',', '.') : '' }}</b>
                    </td>
                    <td class="right text-bold">
                        <b>{{ isset($row3['capaian']) ? number_format($row3['capaian'], 2, ',', '.') . '%' : '' }}</b>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <br><br>
    <table width="100%" style="border: none; margin-top: 40px;">
        <tr>
            <td style="border: none; width: 60%;"></td>
            <td style="border: none; text-align: center;">
                Bojonegoro, {{ \Carbon\Carbon::now()->translatedFormat('d F Y') }}<br>
                KEPALA BADAN PENDAPATAN DAERAH,<br>
                KABUPATEN BOJONEGORO<br><br><br><br>
                <u><b>YUSNITA LIASARI, ST, M.Si</b></u><br>
                Pembina Utama Muda
                <br>
                NIP. 19721127 199803 1 006
            </td>
        </tr>
    </table>
</body>

</html>
