#!/bin/bash

# Laravel Deployment Script for cPanel
echo "Starting Laravel deployment to cPanel..."

# 1. Install PHP dependencies
echo "Installing Composer dependencies..."
composer install --optimize-autoloader --no-dev

# 2. Build frontend assets
echo "Building frontend assets..."
npm ci
npm run build

# 3. Clear and cache Laravel configurations
echo "Optimizing Laravel..."
php artisan config:clear
php artisan config:cache
php artisan route:cache
php artisan view:cache

# 4. Run migrations (if needed)
echo "Running database migrations..."
php artisan migrate --force

# 5. Set permissions (adjust paths for your server)
echo "Setting permissions..."
chmod -R 755 storage
chmod -R 755 bootstrap/cache

echo "Deployment completed successfully!"
echo "Don't forget to:"
echo "1. Update .env file with production settings"
echo "2. Generate APP_KEY: php artisan key:generate"
echo "3. Set proper file permissions on the server"