<?php

namespace App\Http\Controllers;

use App\Models\Target;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TargetController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    // public function __construct()
    // {
    //     $this->middleware('permission:target-list|target-create|target-edit|target-delete', ['only' => ['index', 'store']]);
    //     $this->middleware('permission:target-create', ['only' => ['create', 'store']]);
    //     $this->middleware('permission:target-edit', ['only' => ['edit', 'update']]);
    //     $this->middleware('permission:target-delete', ['only' => ['destroy']]);
    // }

    public function index(Request $request): View
    {
        $data = DB::table('tbl_target')
            ->select(
                'tbl_target.id_target',
                'tbl_target.tahun',
                'ref_jadwal.jadwal',
                'ref_opd.nm_opd',
                DB::raw("CONCAT(
                tbl_target.kd_rek1, '.',
                tbl_target.kd_rek2, '.',
                tbl_target.kd_rek3, '.',
                tbl_target.kd_rek4, '.',
                tbl_target.kd_rek5, '.',
                tbl_target.kd_rek6) AS kd_rekening"),
                'ref_rek6.nm_rek6',
                'tbl_target.keterangan',
                'tbl_target.nilai'
            )
            ->join('ref_jadwal', 'ref_jadwal.kd_jadwal', '=', 'tbl_target.kd_jadwal')
            ->join('ref_opd', 'ref_opd.kd_opd', '=', 'tbl_target.kd_opd')
            ->join(
                'ref_rek6',
                function ($join) {
                    $join->on(
                        'ref_rek6.kd_rek1',
                        '=',
                        'tbl_target.kd_rek1'
                    )
                        ->on(
                            'ref_rek6.kd_rek2',
                            '=',
                            'tbl_target.kd_rek2'
                        )
                        ->on(
                            'ref_rek6.kd_rek3',
                            '=',
                            'tbl_target.kd_rek3'
                        )->on(
                            'ref_rek6.kd_rek4',
                            '=',
                            'tbl_target.kd_rek4',
                        )->on(
                            'ref_rek6.kd_rek5',
                            '=',
                            'tbl_target.kd_rek5'
                        )->on(
                            'ref_rek6.kd_rek6',
                            '=',
                            'tbl_target.kd_rek6'
                        );
                }
            )
            ->get();
        return view('target.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $jadwal = DB::select("SELECT * FROM ref_jadwal");
        $rekening = DB::select("SELECT * FROM ref_rek6");
        $d_opd = DB::select("SELECT * FROM ref_opd");
        return view('target.create', compact('rekening', 'd_opd', 'jadwal'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'opd' => 'required',
            'jadwal' => 'required',
            'keterangan' => 'required',
            'rekening' => 'required'
        ]);
        $rekening = $request->input('rekening');
        $kd_rek = explode('.', $rekening);
        $kd_rek1 = $kd_rek[0];
        $kd_rek2 = $kd_rek[1];
        $kd_rek3 = $kd_rek[2];
        $kd_rek4 = $kd_rek[3];
        $kd_rek5 = $kd_rek[4];
        $kd_rek6 = $kd_rek[5];

        $input = [
            'tahun' => $request->input('tahun'),
            'kd_opd' => $request->input('opd'),
            'kd_jadwal' => $request->input('jadwal'),
            'kd_rek1' => $kd_rek1,
            'kd_rek2' => $kd_rek2,
            'kd_rek3' => $kd_rek3,
            'kd_rek4' => $kd_rek4,
            'kd_rek5' => $kd_rek5,
            'kd_rek6' => $kd_rek6,
            'keterangan' => $request->input('keterangan'),
            'nilai' => $request->input('nilai'),
        ];
        DB::table('tbl_target')->insert($input);
        return redirect()->route('target.index')
            ->with('success', 'Target Berhasil Diinput');
    }

    /**
     * Display the specified resource.
     */
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $target =  DB::table('tbl_target')
            ->select(
                'tbl_target.id_target',
                'tbl_target.tahun',
                'tbl_target.kd_jadwal',
                'ref_jadwal.jadwal',
                'tbl_target.kd_opd',
                'ref_opd.nm_opd',
                DB::raw("CONCAT(
                tbl_target.kd_rek1, '.',
                tbl_target.kd_rek2, '.',
                tbl_target.kd_rek3, '.',
                tbl_target.kd_rek4, '.',
                tbl_target.kd_rek5, '.',
                tbl_target.kd_rek6) AS kd_rekening"),
                'ref_rek6.nm_rek6',
                'tbl_target.keterangan',
                'tbl_target.nilai'
            )
            ->join('ref_jadwal', 'ref_jadwal.kd_jadwal', '=', 'tbl_target.kd_jadwal')
            ->join('ref_opd', 'ref_opd.kd_opd', '=', 'tbl_target.kd_opd')
            ->join(
                'ref_rek6',
                function ($join) {
                    $join->on(
                        'ref_rek6.kd_rek1',
                        '=',
                        'tbl_target.kd_rek1'
                    )
                        ->on(
                            'ref_rek6.kd_rek2',
                            '=',
                            'tbl_target.kd_rek2'
                        )
                        ->on(
                            'ref_rek6.kd_rek3',
                            '=',
                            'tbl_target.kd_rek3'
                        )->on(
                            'ref_rek6.kd_rek4',
                            '=',
                            'tbl_target.kd_rek4',
                        )->on(
                            'ref_rek6.kd_rek5',
                            '=',
                            'tbl_target.kd_rek5'
                        )->on(
                            'ref_rek6.kd_rek6',
                            '=',
                            'tbl_target.kd_rek6'
                        );
                }
            )->where('id_target', $id)->first();
        $jadwal = DB::select("SELECT * FROM ref_jadwal");
        $rekening = DB::select("SELECT * FROM ref_rek6");
        $d_opd = DB::select("SELECT * FROM ref_opd");
        return view('target.edit', compact('target', 'rekening', 'd_opd', 'jadwal'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, int $id)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'opd' => 'required',
            'jadwal' => 'required',
            'keterangan' => 'required',
            'rekening' => 'required'
        ]);
        $rekening = $request->input('rekening');
        $kd_rek = explode('.', $rekening);
        $kd_rek1 = $kd_rek[0];
        $kd_rek2 = $kd_rek[1];
        $kd_rek3 = $kd_rek[2];
        $kd_rek4 = $kd_rek[3];
        $kd_rek5 = $kd_rek[4];
        $kd_rek6 = $kd_rek[5];

        $input = [
            'tahun' => $request->input('tahun'),
            'kd_opd' => $request->input('opd'),
            'kd_jadwal' => $request->input('jadwal'),
            'kd_rek1' => $kd_rek1,
            'kd_rek2' => $kd_rek2,
            'kd_rek3' => $kd_rek3,
            'kd_rek4' => $kd_rek4,
            'kd_rek5' => $kd_rek5,
            'kd_rek6' => $kd_rek6,
            'keterangan' => $request->input('keterangan'),
            'nilai' => $request->input('nilai'),
        ];
        DB::table('tbl_target')->where('id_target', $id)->update($input);
        return redirect()->route('target.index')
            ->with('success', 'Target Berhasil Diubah');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        DB::table('tbl_target')->where('id_target', $id)->delete();
        return redirect()->route('target.index')
            ->with('success', 'Target Berhasil Dihapus');
    }
}
