<?php

namespace App\Http\Controllers;

use App\Models\Pembiayaan;
use Illuminate\Contracts\View\View;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PembiayaanController extends Controller
{
    public function index(Request $request): View
    {
        $data = DB::table('tbl_pembiayaan')
            ->select(
                'tbl_pembiayaan.id_pembiayaan',
                'tbl_pembiayaan.tahun',
                'tbl_pembiayaan.tgl_transaksi',
                'tbl_pembiayaan.keterangan',
                'tbl_pembiayaan.nilai',
            )
            ->orderBy('tgl_transaksi')
            ->get();
        // $transaksi = $data->groupBy('tgl_transaksi')->map(function ($items) {
        //     return $items->groupBy('kd_rekening');
        // });

        // $totals = $data->groupBy('tgl_transaksi')->map(function ($items) {
        //     return $items->sum('nilai');
        // });

        return view('pembiayaan.index', compact('data'));
    }
    public function create()
    {
        return view('pembiayaan.create');
    }
    public function store(Request $request)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'tgl_transaksi' => 'required',
            'keterangan' => 'required'
        ]);

        $input = [
            'tahun' => $request->input('tahun'),
            'tgl_transaksi' => $request->input('tgl_transaksi'),
            'keterangan' => $request->input('keterangan'),
            'nilai' => $request->input('nilai'),
            'tgl_input' => now()
        ];
        DB::table('tbl_pembiayaan')->insert($input);
        return redirect()->route('pembiayaan.index')
            ->with('success', 'Pembiayaan Berhasil Diinput');
    }
    public function edit(string $id)
    {
        $pembiayaan =  DB::table('tbl_pembiayaan')
            ->select(
                'tbl_pembiayaan.id_pembiayaan',
                'tbl_pembiayaan.tahun',
                'tbl_pembiayaan.tgl_transaksi',
                'tbl_pembiayaan.keterangan',
                'tbl_pembiayaan.nilai'
            )->where('id_pembiayaan', $id)->first();
        return view('pembiayaan.edit', compact('pembiayaan'));
    }
    public function update(Request $request, int $id)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'tgl_transaksi' => 'required',
            'keterangan' => 'required'
        ]);


        $input = [
            'tahun' => $request->input('tahun'),
            'tgl_transaksi' => $request->input('tgl_transaksi'),
            'keterangan' => $request->input('keterangan'),
            'nilai' => $request->input('nilai'),
            'tgl_input' => now()
        ];

        DB::table('tbl_pembiayaan')->where('id_pembiayaan', $id)->update($input);
        return redirect()->route('pembiayaan.index')
            ->with('success', 'Pembiayaan Berhasil Diedit');
    }
    public function destroy(string $id)
    {
        DB::table('tbl_pembiayaan')->where('id_pembiayaan', $id)->delete();
        return redirect()->route('pembiayaan.index')
            ->with('success', 'Pembiayaan Berhasil Dihapus');
    }
}
