<?php

namespace App\Http\Controllers;

use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;

class LaporanController extends Controller
{
    public function index()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');

        if (Auth::user()->hasRole('Admin')) {
            $d_opd = DB::select("SELECT * FROM ref_opd");
        } else {
            $d_opd = DB::select("SELECT * FROM ref_opd WHERE kd_opd == $opd_user");
        }
        return view('laporan.index', compact('d_opd'));
    }

    // LAPORAN BUPATI
    public function laporanBupatiOpd()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');
        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");

        if (Auth::user()->hasRole('Admin')) {
            $d_opd = DB::select("SELECT * FROM ref_opd");
        } else {
            $d_opd = DB::select("SELECT * FROM ref_opd WHERE kd_opd = $opd_user");
        }
        return view('laporan.laporan_bupati_opd', compact('d_opd', 'jadwal'));
    }

    public function laporanBupatiOpdPdf(Request $request)
    {
        $this->validate($request, [
            'tahun' => 'required',
            'opd' => 'required',
            'dari_tanggal' => 'required',
            'sampai_tanggal' => 'required',
            'jadwal' => 'required'
        ]);

        $tahun = $request->input('tahun');
        $opd = $request->input('opd');
        $daritanggal = $request->input('dari_tanggal');
        $sampaitanggal = $request->input('sampai_tanggal');
        $jadwal = $request->input('jadwal');

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();
            $ref_opd = DB::table('ref_opd')->where('kd_opd', $opd)->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_opd', $opd)
                ->whereDate('tgl_transaksi', '>=', $daritanggal)
                ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_jadwal', $jadwal)
                ->where('kd_opd', $opd)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($total2 / $target2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($total3 / $target3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? ($total4 / $target4) * 100 : 0;
                                $rows[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => true,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? ($total5 / $target5) * 100 : 0;
                                    $rows[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $total6 = $this->hitungTotal($transaksi, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $target6 = $this->hitungTarget($targets, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($total6 > 0 || $target6 > 0) {
                                        $capaian6 = $target6 > 0 ? ($total6 / $target6) * 100 : 0;
                                        $rows[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $total6,
                                            'target' => $target6,
                                            'capaian' => $capaian6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $rows2 = [];
            foreach ($rek1 as $r1) {
                $total1 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $target1 = $this->hitungTarget($targets, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaian1 = $target1 > 0 ? ($total1 / $target1) * 100 : 0;
                $rows2[] = [
                    'total' => $total1,
                    'target' => $target1,
                    'capaian' => $capaian1,
                ];
            }
            $pdf = Pdf::loadView('laporan.laporan_bupati_opd_pdf', compact('rows', 'rows2', 'ref_opd', 'daritanggal', 'sampaitanggal'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_bupati_opd_induk.pdf');
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();
            $ref_opd = DB::table('ref_opd')->where('kd_opd', $opd)->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_opd', $opd)
                ->whereDate('tgl_transaksi', '>=', $daritanggal)
                ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_jadwal', '=', 1)
                ->where('kd_opd', $opd)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_jadwal', '=', 2)
                ->where('kd_opd', $opd)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? ($total4 / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? ($total4 / $targetperubahan4) * 100 : 0;
                                $rows[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => true,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $targetinduk5 > 0  || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? ($total5 / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? ($total5 / $targetperubahan5) * 100 : 0;
                                    $rows[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $total6 = $this->hitungTotal($transaksi, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetinduk6 = $this->hitungTarget($targetsinduk, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetperubahan6 = $this->hitungTarget($targetsperubahan, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($total6 > 0 || $targetinduk6 > 0 || $targetperubahan6 > 0) {
                                        $capaianinduk6 = $targetinduk6 > 0 ? ($total6 / $targetinduk6) * 100 : 0;
                                        $capaianperubahan6 = $targetperubahan6 > 0 ? ($total6 / $targetperubahan6) * 100 : 0;
                                        $rows[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $total6,
                                            'targetinduk' => $targetinduk6,
                                            'targetperubahan' => $targetperubahan6,
                                            'capaianinduk' => $capaianinduk6,
                                            'capaianperubahan' => $capaianperubahan6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $rows2 = [];
            foreach ($rek1 as $r1) {
                $total1 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? ($total1 / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? ($total1 / $targetperubahan1) * 100 : 0;
                $rows2[] = [
                    'total' => $total1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }
            $pdf = Pdf::loadView('laporan.laporan_bupati_opd_papbd_pdf', compact('rows', 'rows2', 'ref_opd', 'daritanggal', 'sampaitanggal'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_bupati_opd_perubahan.pdf');
        }
    }

    public function laporanBupatiOpdExcel()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');
        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");

        if (Auth::user()->hasRole('Admin')) {
            $d_opd = DB::select("SELECT * FROM ref_opd");
        } else {
            $d_opd = DB::select("SELECT * FROM ref_opd WHERE kd_opd = $opd_user");
        }
        return view('laporan.laporan_bupati_opd_ex', compact('d_opd', 'jadwal'));
    }

    public function exportExcelLaporanBupatiOpd(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'opd' => 'required',
            'dari_tanggal' => 'required',
            'sampai_tanggal' => 'required',
            'tahun' => 'required'
        ]);
        $tahun = $request->input('tahun');
        $jadwal = $request->input('jadwal');
        $opd = $request->input('opd');
        $daritanggal = $request->input('dari_tanggal');
        $sampaitanggal = $request->input('sampai_tanggal');

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();
            $ref_opd = DB::table('ref_opd')->where('kd_opd', $opd)->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_opd', $opd)
                ->whereDate('tgl_transaksi', '>=', $daritanggal)
                ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', $tahun)
                ->where('kd_jadwal', '=', 1)
                ->where('kd_opd', $opd)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();


            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('D1', 'Realisasi');
            $sheet->setCellValue('E1', '% Capaian');

            // Data dummy, kamu bisa load dari database
            $data = [];

            // Buat array laporan akhir
            $rows = [];

            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($total2 / $target2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($total3 / $target3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? ($total4 / $target4) * 100 : 0;
                                $rows[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? ($total5 / $target5) * 100 : 0;
                                    $rows[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $total6 = $this->hitungTotal($transaksi, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $target6 = $this->hitungTarget($targets, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($total6 > 0 || $target6 > 0) {
                                        $capaian6 = $target6 > 0 ? ($total6 / $target6) * 100 : 0;
                                        $rows[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $total6,
                                            'target' => $target6,
                                            'capaian' => $capaian6,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $row = 2;
            foreach ($rows as $item1) {
                $sheet->setCellValue("A$row", $item1['kode']);
                $sheet->setCellValue("B$row", $item1['nama']);
                $sheet->setCellValue("C$row", $item1['target']);
                $sheet->setCellValue("D$row", $item1['total']);
                $sheet->setCellValue("E$row", $item1['capaian']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporanopdbupati.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_opd', $opd)
                ->whereDate('tgl_transaksi', '>=', $daritanggal)
                ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_opd', $opd)
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_opd', $opd)
                ->where('kd_jadwal', '=', 2)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:D1');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('C2', 'Target Induk');
            $sheet->setCellValue('D2', 'Target Perubahan');
            $sheet->mergeCells('E1:E2');
            $sheet->setCellValue('E1', 'Realisasi');
            $sheet->mergeCells('F1:G1');
            $sheet->setCellValue('F1', '% Capaian');
            $sheet->setCellValue('F2', '% Capaian Induk');
            $sheet->setCellValue('G2', '% Capaian Perubahan');
            // Data dummy, kamu bisa load dari database
            $data = [];

            // Buat array laporan akhir
            $rows = [];

            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? ($total4 / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? ($total4 / $targetperubahan4) * 100 : 0;
                                $rows[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? ($total5 / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? ($total5 / $targetperubahan5) * 100 : 0;
                                    $rows[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $total6 = $this->hitungTotal($transaksi, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetinduk6 = $this->hitungTarget($targetsinduk, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetperubahan6 = $this->hitungTarget($targetsperubahan, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($total6 > 0 || $targetinduk6 > 0 || $targetperubahan6 > 0) {
                                        $capaianinduk6 = $targetinduk6 > 0 ? ($total6 / $targetinduk6) * 100 : 0;
                                        $capaianperubahan6 = $targetperubahan6 > 0 ? ($total6 / $targetperubahan6) * 100 : 0;
                                        $rows[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $total6,
                                            'targetinduk' => $targetinduk6,
                                            'targetperubahan' => $targetperubahan6,
                                            'capaianinduk' => $capaianinduk6,
                                            'capaianperubahan' => $capaianperubahan6,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $row = 3;
            foreach ($rows as $item1) {
                $sheet->setCellValue("A$row", $item1['kode']);
                $sheet->setCellValue("B$row", $item1['nama']);
                $sheet->setCellValue("C$row", $item1['targetinduk']);
                $sheet->setCellValue("D$row", $item1['targetperubahan']);
                $sheet->setCellValue("E$row", $item1['total']);
                $sheet->setCellValue("F$row", $item1['capaianinduk']);
                $sheet->setCellValue("G$row", $item1['capaianperubahan']);
                $row++;
            }
            // Simpan ke file sementara
            $filename = 'laporankabbupatiopdperubahan.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        }
    }

    public function laporanRekeningBupati(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required'
        ]);
        $tahun = $request->input('tahun');
        $jadwal = $request->input('jadwal');
        $bulan = $request->input('bulan');

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulan)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targets = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            // Buat array laporan akhir
            $rows1 = [];

            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($total2 / $target2) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }

                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($total3 / $target3) * 100 : 0;
                            $rows1[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($total2 / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($total3 / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? ($total4 / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? ($total5 / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $total1 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $target1 = $this->hitungTarget($targets, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaian1 = $target1 > 0 ? ($total1 / $target1) * 100 : 0;
                $rows3[] = [
                    'total' => $total1,
                    'target' => $target1,
                    'capaian' => $capaian1,
                ];
            }
            $pdf = Pdf::loadView('laporan.laporan_bupati_kab_pdf', compact('rows1', 'rows2', 'rows3'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_bupati_kab.pdf');
        } else {

            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulan)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_jadwal', '=', 2)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            // Buat array laporan akhir
            $rows1 = [];

            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }

                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                            $rows1[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                            $rows1[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => false,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? ($total4 / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? ($total4 / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? ($total5 / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? ($total5 / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $total1 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? ($total1 / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? ($total1 / $targetperubahan1) * 100 : 0;
                $rows3[] = [
                    'total' => $total1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }
            $pdf = Pdf::loadView('laporan.laporan_bupati_kab_papbd_pdf', compact('rows1', 'rows2', 'rows3'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_bupati_papbd_kab.pdf');
        }
    }

    public function laporanBupati()
    {
        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");

        return view('laporan.laporan_bupati', compact('jadwal'));
    }

    public function laporanBupatiExcel()
    {
        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");

        return view('laporan.laporan_bupati_excel', compact('jadwal'));
    }

    public function exportExcelLaporanRekeningBupati(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'tahun' => 'required',
            'bulan' => 'required'
        ]);
        $tahun = $request->input('tahun');
        $jadwal = $request->input('jadwal');
        $bulan = $request->input('bulan');

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulan)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targets = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();


            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // HEADER
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('D1', 'Realisasi');
            $sheet->setCellValue('E1', '% Capaian');

            // Data dummy, kamu bisa load dari database
            $data = [];

            // Buat array laporan akhir
            $rows1 = [];

            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($total2 / $target2) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }

                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($total3 / $target3) * 100 : 0;
                            $rows1[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($total2 / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($total3 / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? ($total4 / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? ($total5 / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $total1 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $target1 = $this->hitungTarget($targets, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaian1 = $target1 > 0 ? ($total1 / $target1) * 100 : 0;
                $rows3[] = [
                    'total' => $total1,
                    'target' => $target1,
                    'capaian' => $capaian1,
                ];
            }

            $row = 2;
            foreach ($rows1 as $item1) {
                $sheet->setCellValue("A$row", $item1['kode']);
                $sheet->setCellValue("B$row", $item1['nama']);
                $sheet->setCellValue("C$row", $item1['target']);
                $sheet->setCellValue("D$row", $item1['total']);
                $sheet->setCellValue("E$row", $item1['capaian']);
                $row++;
            }
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['target']);
                $sheet->setCellValue("D$row", $item2['total']);
                $sheet->setCellValue("E$row", $item2['capaian']);
                $row++;
            }
            foreach ($rows3 as $item3) {
                $sheet->setCellValue("B$row", "TOTAL PENDAPATAN");
                $sheet->setCellValue("C$row", $item3['target']);
                $sheet->setCellValue("D$row", $item3['total']);
                $sheet->setCellValue("E$row", $item3['capaian']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporankabbupatiinduk.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulan)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_jadwal', '=', 2)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:D1');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('C2', 'Target Induk');
            $sheet->setCellValue('D2', 'Target Perubahan');
            $sheet->mergeCells('E1:E2');
            $sheet->setCellValue('E1', 'Realisasi');
            $sheet->mergeCells('F1:G1');
            $sheet->setCellValue('F1', '% Capaian');
            $sheet->setCellValue('F2', '% Capaian Induk');
            $sheet->setCellValue('G2', '% Capaian Perubahan');

            // Buat array laporan akhir
            $rows1 = [];

            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }

                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                            $rows1[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $total2 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($total2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $total2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $total3 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                            $rows1[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $total3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => false,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $total4 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($total4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? ($total4 / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? ($total4 / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $total4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $total5 = $this->hitungTotal($transaksi, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($total5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? ($total5 / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? ($total5 / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $total5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $total1 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? ($total1 / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? ($total1 / $targetperubahan1) * 100 : 0;
                $rows3[] = [
                    'total' => $total1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }
            $row = 3;
            foreach ($rows1 as $item1) {
                $sheet->setCellValue("A$row", $item1['kode']);
                $sheet->setCellValue("B$row", $item1['nama']);
                $sheet->setCellValue("C$row", $item1['targetinduk']);
                $sheet->setCellValue("D$row", $item1['targetperubahan']);
                $sheet->setCellValue("E$row", $item1['total']);
                $sheet->setCellValue("F$row", $item1['capaianinduk']);
                $sheet->setCellValue("G$row", $item1['capaianperubahan']);
                $row++;
            }
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['targetinduk']);
                $sheet->setCellValue("D$row", $item2['targetperubahan']);
                $sheet->setCellValue("E$row", $item2['total']);
                $sheet->setCellValue("F$row", $item2['capaianinduk']);
                $sheet->setCellValue("G$row", $item2['capaianperubahan']);
                $row++;
            }
            foreach ($rows3 as $item3) {
                $sheet->setCellValue("B$row", "TOTAL PENDAPATAN");
                $sheet->setCellValue("C$row", $item3['targetinduk']);
                $sheet->setCellValue("D$row", $item3['targetperubahan']);
                $sheet->setCellValue("E$row", $item3['total']);
                $sheet->setCellValue("F$row", $item3['capaianinduk']);
                $sheet->setCellValue("G$row", $item3['capaianperubahan']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporankabbupatiperubahan.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        }
    }

    public function show() {}


    // LAPORAN TRANSAKSI HARIAN
    public function laporanRincianKab()
    {
        $d_opd = DB::select("SELECT * FROM ref_opd");
        return view('laporan.laporan_rincian_kab', compact('d_opd'));
    }
    public function laporanRincianKabPdf(Request $request)
    {
        // $this->validate($request, [
        //     'dari_tanggal' => 'required',
        //     'sampai_tanggal' => 'required',
        //     'opd' => 'required'
        // ]);

        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');
        $opd = $request->input('opd');

        if (Auth::user()->hasRole('Admin')) {
            if ($opd != 0) {
                $daritanggal = $request->input('dari_tanggal');
                $sampaitanggal = $request->input('sampai_tanggal');

                $transaksis = DB::table('tbl_pendapatan')
                    ->join('ref_opd', 'tbl_pendapatan.kd_opd', '=', 'ref_opd.kd_opd')
                    ->join('ref_rek6', function ($join) {
                        $join->on('tbl_pendapatan.kd_rek1', '=', 'ref_rek6.kd_rek1')
                            ->on('tbl_pendapatan.kd_rek2', '=', 'ref_rek6.kd_rek2')
                            ->on('tbl_pendapatan.kd_rek3', '=', 'ref_rek6.kd_rek3')
                            ->on('tbl_pendapatan.kd_rek4', '=', 'ref_rek6.kd_rek4')
                            ->on('tbl_pendapatan.kd_rek5', '=', 'ref_rek6.kd_rek5')
                            ->on('tbl_pendapatan.kd_rek6', '=', 'ref_rek6.kd_rek6');
                    })
                    ->select(
                        'tbl_pendapatan.tgl_transaksi',
                        'ref_opd.nm_opd',
                        DB::raw("CONCAT(tbl_pendapatan.kd_rek1, '.', tbl_pendapatan.kd_rek2, '.', tbl_pendapatan.kd_rek3, '.', tbl_pendapatan.kd_rek4, '.', tbl_pendapatan.kd_rek5, '.', tbl_pendapatan.kd_rek6, ' ', ref_rek6.nm_rek6) as rekening"),
                        'tbl_pendapatan.keterangan',
                        'tbl_pendapatan.nilai'
                    )
                    ->where('tbl_pendapatan.kd_opd', '=', $opd)
                    ->whereDate('tgl_transaksi', '>=', $daritanggal)
                    ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                    ->orderBy('tbl_pendapatan.tgl_transaksi')
                    ->orderBy('ref_opd.nm_opd')
                    ->get()
                    ->groupBy('tgl_transaksi');
            } else {
                $daritanggal = $request->input('dari_tanggal');
                $sampaitanggal = $request->input('sampai_tanggal');

                $transaksis = DB::table('tbl_pendapatan')
                    ->join('ref_opd', 'tbl_pendapatan.kd_opd', '=', 'ref_opd.kd_opd')
                    ->join('ref_rek6', function ($join) {
                        $join->on('tbl_pendapatan.kd_rek1', '=', 'ref_rek6.kd_rek1')
                            ->on('tbl_pendapatan.kd_rek2', '=', 'ref_rek6.kd_rek2')
                            ->on('tbl_pendapatan.kd_rek3', '=', 'ref_rek6.kd_rek3')
                            ->on('tbl_pendapatan.kd_rek4', '=', 'ref_rek6.kd_rek4')
                            ->on('tbl_pendapatan.kd_rek5', '=', 'ref_rek6.kd_rek5')
                            ->on('tbl_pendapatan.kd_rek6', '=', 'ref_rek6.kd_rek6');
                    })
                    ->select(
                        'tbl_pendapatan.tgl_transaksi',
                        'ref_opd.nm_opd',
                        DB::raw("CONCAT(tbl_pendapatan.kd_rek1, '.', tbl_pendapatan.kd_rek2, '.', tbl_pendapatan.kd_rek3, '.', tbl_pendapatan.kd_rek4, '.', tbl_pendapatan.kd_rek5, '.', tbl_pendapatan.kd_rek6, ' ', ref_rek6.nm_rek6) as rekening"),
                        'tbl_pendapatan.keterangan',
                        'tbl_pendapatan.nilai'
                    )
                    ->whereDate('tgl_transaksi', '>=', $daritanggal)
                    ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                    ->orderBy('tbl_pendapatan.tgl_transaksi')
                    ->orderBy('ref_opd.nm_opd')
                    ->get()
                    ->groupBy('tgl_transaksi');
            }
        } else {
            $daritanggal = $request->input('dari_tanggal');
            $sampaitanggal = $request->input('sampai_tanggal');

            $transaksis = DB::table('tbl_pendapatan')
                ->join('ref_opd', 'tbl_pendapatan.kd_opd', '=', 'ref_opd.kd_opd')
                ->join('ref_rek6', function ($join) {
                    $join->on('tbl_pendapatan.kd_rek1', '=', 'ref_rek6.kd_rek1')
                        ->on('tbl_pendapatan.kd_rek2', '=', 'ref_rek6.kd_rek2')
                        ->on('tbl_pendapatan.kd_rek3', '=', 'ref_rek6.kd_rek3')
                        ->on('tbl_pendapatan.kd_rek4', '=', 'ref_rek6.kd_rek4')
                        ->on('tbl_pendapatan.kd_rek5', '=', 'ref_rek6.kd_rek5')
                        ->on('tbl_pendapatan.kd_rek6', '=', 'ref_rek6.kd_rek6');
                })
                ->select(
                    'tbl_pendapatan.tgl_transaksi',
                    'ref_opd.nm_opd',
                    DB::raw("CONCAT(tbl_pendapatan.kd_rek1, '.', tbl_pendapatan.kd_rek2, '.', tbl_pendapatan.kd_rek3, '.', tbl_pendapatan.kd_rek4, '.', tbl_pendapatan.kd_rek5, '.', tbl_pendapatan.kd_rek6, ' ', ref_rek6.nm_rek6) as rekening"),
                    'tbl_pendapatan.keterangan',
                    'tbl_pendapatan.nilai'
                )
                ->where('tbl_pendapatan.kd_opd', '=', $opd_user)
                ->whereDate('tbl_pendapatan.tgl_transaksi', '>=', $daritanggal)
                ->whereDate('tbl_pendapatan.tgl_transaksi', '<=', $sampaitanggal)
                ->orderBy('tbl_pendapatan.tgl_transaksi')
                ->orderBy('ref_opd.nm_opd')
                ->get()
                ->groupBy('tgl_transaksi');
        }

        $pdf = Pdf::loadView('laporan.laporan_rincian_pdf', compact('transaksis', 'daritanggal', 'sampaitanggal'))->setPaper('folio', 'landscape');

        return $pdf->download('laporan_rincian.pdf');
    }
    public function exportExcelTransaksiHarian(Request $request)
    {
        // $this->validate($request, [
        //     'dari_tanggal' => 'required',
        //     'sampai_tanggal' => 'required',
        //     'opd' => 'required'
        // ]);

        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');
        $opd = $request->input('opd');


        if (Auth::user()->hasRole('Admin')) {
            if ($opd != 0) {
                $daritanggal = $request->input('dari_tanggal');
                $sampaitanggal = $request->input('sampai_tanggal');

                $transaksis = DB::table('tbl_pendapatan')
                    ->join('ref_opd', 'tbl_pendapatan.kd_opd', '=', 'ref_opd.kd_opd')
                    ->join('ref_rek6', function ($join) {
                        $join->on('tbl_pendapatan.kd_rek1', '=', 'ref_rek6.kd_rek1')
                            ->on('tbl_pendapatan.kd_rek2', '=', 'ref_rek6.kd_rek2')
                            ->on('tbl_pendapatan.kd_rek3', '=', 'ref_rek6.kd_rek3')
                            ->on('tbl_pendapatan.kd_rek4', '=', 'ref_rek6.kd_rek4')
                            ->on('tbl_pendapatan.kd_rek5', '=', 'ref_rek6.kd_rek5')
                            ->on('tbl_pendapatan.kd_rek6', '=', 'ref_rek6.kd_rek6');
                    })
                    ->select(
                        'tbl_pendapatan.tgl_transaksi',
                        'ref_opd.nm_opd',
                        DB::raw("CONCAT(tbl_pendapatan.kd_rek1, '.', tbl_pendapatan.kd_rek2, '.', tbl_pendapatan.kd_rek3, '.', tbl_pendapatan.kd_rek4, '.', tbl_pendapatan.kd_rek5, '.', tbl_pendapatan.kd_rek6, ' ', ref_rek6.nm_rek6) as rekening"),
                        'tbl_pendapatan.keterangan',
                        'tbl_pendapatan.nilai'
                    )
                    ->where('tbl_pendapatan.kd_opd', '=', $opd)
                    ->whereDate('tgl_transaksi', '>=', $daritanggal)
                    ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                    ->orderBy('tbl_pendapatan.tgl_transaksi')
                    ->orderBy('ref_opd.nm_opd')
                    ->get()
                    ->groupBy('tgl_transaksi');
            } else {
                $daritanggal = $request->input('dari_tanggal');
                $sampaitanggal = $request->input('sampai_tanggal');

                $transaksis = DB::table('tbl_pendapatan')
                    ->join('ref_opd', 'tbl_pendapatan.kd_opd', '=', 'ref_opd.kd_opd')
                    ->join('ref_rek6', function ($join) {
                        $join->on('tbl_pendapatan.kd_rek1', '=', 'ref_rek6.kd_rek1')
                            ->on('tbl_pendapatan.kd_rek2', '=', 'ref_rek6.kd_rek2')
                            ->on('tbl_pendapatan.kd_rek3', '=', 'ref_rek6.kd_rek3')
                            ->on('tbl_pendapatan.kd_rek4', '=', 'ref_rek6.kd_rek4')
                            ->on('tbl_pendapatan.kd_rek5', '=', 'ref_rek6.kd_rek5')
                            ->on('tbl_pendapatan.kd_rek6', '=', 'ref_rek6.kd_rek6');
                    })
                    ->select(
                        'tbl_pendapatan.tgl_transaksi',
                        'ref_opd.nm_opd',
                        DB::raw("CONCAT(tbl_pendapatan.kd_rek1, '.', tbl_pendapatan.kd_rek2, '.', tbl_pendapatan.kd_rek3, '.', tbl_pendapatan.kd_rek4, '.', tbl_pendapatan.kd_rek5, '.', tbl_pendapatan.kd_rek6, ' ', ref_rek6.nm_rek6) as rekening"),
                        'tbl_pendapatan.keterangan',
                        'tbl_pendapatan.nilai'
                    )
                    ->whereDate('tgl_transaksi', '>=', $daritanggal)
                    ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
                    ->orderBy('tbl_pendapatan.tgl_transaksi')
                    ->orderBy('ref_opd.nm_opd')
                    ->get()
                    ->groupBy('tgl_transaksi');
            }
        } else {
            $daritanggal = $request->input('dari_tanggal');
            $sampaitanggal = $request->input('sampai_tanggal');

            $transaksis = DB::table('tbl_pendapatan')
                ->join('ref_opd', 'tbl_pendapatan.kd_opd', '=', 'ref_opd.kd_opd')
                ->join('ref_rek6', function ($join) {
                    $join->on('tbl_pendapatan.kd_rek1', '=', 'ref_rek6.kd_rek1')
                        ->on('tbl_pendapatan.kd_rek2', '=', 'ref_rek6.kd_rek2')
                        ->on('tbl_pendapatan.kd_rek3', '=', 'ref_rek6.kd_rek3')
                        ->on('tbl_pendapatan.kd_rek4', '=', 'ref_rek6.kd_rek4')
                        ->on('tbl_pendapatan.kd_rek5', '=', 'ref_rek6.kd_rek5')
                        ->on('tbl_pendapatan.kd_rek6', '=', 'ref_rek6.kd_rek6');
                })
                ->select(
                    'tbl_pendapatan.tgl_transaksi',
                    'ref_opd.nm_opd',
                    DB::raw("CONCAT(tbl_pendapatan.kd_rek1, '.', tbl_pendapatan.kd_rek2, '.', tbl_pendapatan.kd_rek3, '.', tbl_pendapatan.kd_rek4, '.', tbl_pendapatan.kd_rek5, '.', tbl_pendapatan.kd_rek6, ' ', ref_rek6.nm_rek6) as rekening"),
                    'tbl_pendapatan.keterangan',
                    'tbl_pendapatan.nilai'
                )
                ->where('tbl_pendapatan.kd_opd', '=', $opd_user)
                ->whereDate('tbl_pendapatan.tgl_transaksi', '>=', $daritanggal)
                ->whereDate('tbl_pendapatan.tgl_transaksi', '<=', $sampaitanggal)
                ->orderBy('tbl_pendapatan.tgl_transaksi')
                ->orderBy('ref_opd.nm_opd')
                ->get()
                ->groupBy('tgl_transaksi');
        }

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Header
        $sheet->setCellValue('A1', 'Tanggal');
        $sheet->setCellValue('B1', 'OPD');
        $sheet->setCellValue('C1', 'Rekening');
        $sheet->setCellValue('D1', 'Keterangan');
        $sheet->setCellValue('E1', 'Nominal');

        // Data dummy, kamu bisa load dari database
        $data = [];
        $row = 3;
        // Buat array laporan akhir
        foreach ($transaksis as $tanggal => $itemsByTanggal) {
            $groupedByOpd = $itemsByTanggal->groupBy('nm_opd');
            $totalTanggal = 0;
            foreach ($groupedByOpd as $opd => $itemsByOpd) {
                $firstOpdRow = true;
                $subtotalOpd = 0;
                foreach ($itemsByOpd as $item) {
                    $sheet->setCellValue("A$row", $firstOpdRow ? \Carbon\Carbon::parse($tanggal)->format('d/m/Y') : '');
                    $sheet->setCellValue("B$row",  $firstOpdRow ? $opd : '');
                    $sheet->setCellValue("C$row", $item->rekening);
                    $sheet->setCellValue("D$row", $item->keterangan);
                    $sheet->setCellValue("E$row", $item->nilai);
                    $subtotalOpd += $item->nilai;
                    $totalTanggal += $item->nilai;
                    $firstOpdRow = false;
                    $row++;
                }
            }
            $sheet->setCellValue("A$row", \Carbon\Carbon::parse($tanggal)->format('d/m/Y'));
            $sheet->setCellValue("E$row", $totalTanggal);
            $row++;
        }

        // Simpan ke file sementara
        $filename = 'exceltransaksiharian.xlsx';
        $writer = new Xlsx($spreadsheet);
        $tempPath = storage_path("app/public/{$filename}");
        $writer->save($tempPath);

        // Unduh file
        return response()->download($tempPath)->deleteFileAfterSend(true);
    }
    // LAPORAN RINCIAN PENDAPATAN
    public function laporanRincianPendapatan()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');

        if (Auth::user()->hasRole('Admin')) {
            $d_opd = DB::select("SELECT * FROM ref_opd");
        } else {
            $d_opd = DB::select("SELECT * FROM ref_opd WHERE kd_opd = $opd_user");
        }
        return view('laporan.laporan_rincian_pendapatan', compact('d_opd'));
    }

    public function exportExcelRincianPendapatan(Request $request)
    {
        $this->validate($request, [
            'dari_tanggal' => 'required',
            'sampai_tanggal' => 'required',
            'opd' => 'required',
            'tahun' => 'required'
        ]);

        $tahun = $request->input('tahun');
        $opd = $request->input('opd');
        $daritanggal = $request->input('dari_tanggal');
        $sampaitanggal = $request->input('sampai_tanggal');

        // Ambil data semua level
        $rek1 = DB::table('ref_rek1')->get();
        $rek2 = DB::table('ref_rek2')->get();
        $rek3 = DB::table('ref_rek3')->get();
        $rek4 = DB::table('ref_rek4')->get();
        $rek5 = DB::table('ref_rek5')->get();
        $rek6 = DB::table('ref_rek6')->get();

        // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
        $transaksi = DB::table('tbl_pendapatan')
            ->select(
                'kd_opd',
                'kd_rek1',
                'kd_rek2',
                'kd_rek3',
                'kd_rek4',
                'kd_rek5',
                'kd_rek6',
                'keterangan',
                DB::raw('SUM(nilai) as total')
            )
            ->where('tahun', '=', $tahun)
            ->where('kd_opd', '=', $opd)
            ->whereDate('tgl_transaksi', '>=', $daritanggal)
            ->whereDate('tgl_transaksi', '<=', $sampaitanggal)
            ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6', 'keterangan')
            ->get();

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // HEADER
        $sheet->setCellValue('A1', 'Kode Rekening');
        $sheet->setCellValue('B1', 'Rekening');
        $sheet->setCellValue('C1', 'Keterangan');
        $sheet->setCellValue('D1', 'Total');

        // Data dummy, kamu bisa load dari database
        $data = [];
        $rows2 = [];
        foreach ($rek1 as $r1) {
            foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                    foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                        foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                            foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                foreach ($transaksi->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5)->where('kd_rek6', $r6->kd_rek6) as $ket) {
                                    $totalbulaniniket = $this->hitungTotal($transaksi, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                        'keterangan' => $ket->keterangan,
                                    ]);
                                    if ($totalbulaniniket > 0) {
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'keterangan' => $ket->keterangan,
                                            'total' => $totalbulaniniket,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        $data = [];
        $row = 2;
        // Buat array laporan akhir
        foreach ($rows2 as $item1) {
            $sheet->setCellValue("A$row", $item1['kode']);
            $sheet->setCellValue("B$row", $item1['nama']);
            $sheet->setCellValue("C$row", $item1['keterangan']);
            $sheet->setCellValue("D$row", $item1['total']);
            $row++;
        }

        // Simpan ke file sementara
        $filename = 'excelrincianpendapatan.xlsx';
        $writer = new Xlsx($spreadsheet);
        $tempPath = storage_path("app/public/{$filename}");
        $writer->save($tempPath);

        // Unduh file
        return response()->download($tempPath)->deleteFileAfterSend(true);
    }

    // LAPORAN RINCIAN TARGET
    public function laporanRincianTarget()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');

        if (Auth::user()->hasRole('Admin')) {
            $d_opd = DB::select("SELECT * FROM ref_opd");
        } else {
            $d_opd = DB::select("SELECT * FROM ref_opd WHERE kd_opd = $opd_user");
        }

        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");
        return view('laporan.laporan_rincian_target', compact('jadwal', 'd_opd'));
    }
    public function exportExcelTargetPendapatan(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'opd' => 'required',
            'tahun' => 'required'
        ]);

        $tahun = $request->input('tahun');
        $opd = $request->input('opd');
        $jadwal = $request->input('jadwal');

        // Ambil data semua level
        $rek1 = DB::table('ref_rek1')->get();
        $rek2 = DB::table('ref_rek2')->get();
        $rek3 = DB::table('ref_rek3')->get();
        $rek4 = DB::table('ref_rek4')->get();
        $rek5 = DB::table('ref_rek5')->get();
        $rek6 = DB::table('ref_rek6')->get();

        // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
        $target = DB::table('tbl_target')
            ->select(
                'kd_opd',
                'kd_rek1',
                'kd_rek2',
                'kd_rek3',
                'kd_rek4',
                'kd_rek5',
                'kd_rek6',
                'keterangan',
                DB::raw('SUM(nilai) as total')
            )
            ->where('kd_jadwal', '=', $jadwal)
            ->where('tahun', '=', $tahun)
            ->where('kd_opd', '=', $opd)
            ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6', 'keterangan')
            ->get();

        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // HEADER
        $sheet->setCellValue('A1', 'Kode Rekening');
        $sheet->setCellValue('B1', 'Rekening');
        $sheet->setCellValue('C1', 'Keterangan');
        $sheet->setCellValue('D1', 'Total');

        // Data dummy, kamu bisa load dari database
        $data = [];
        $rows2 = [];
        foreach ($rek1 as $r1) {
            foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                    foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                        foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                            foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                foreach ($target->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5)->where('kd_rek6', $r6->kd_rek6) as $ket) {
                                    $targetket = $this->hitungTotal($target, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                        'keterangan' => $ket->keterangan,
                                    ]);
                                    if ($targetket > 0) {
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'keterangan' => $ket->keterangan,
                                            'total' => $targetket,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        $data = [];
        $row = 2;
        // Buat array laporan akhir
        foreach ($rows2 as $item1) {
            $sheet->setCellValue("A$row", $item1['kode']);
            $sheet->setCellValue("B$row", $item1['nama']);
            $sheet->setCellValue("C$row", $item1['keterangan']);
            $sheet->setCellValue("D$row", $item1['total']);
            $row++;
        }

        // Simpan ke file sementara
        $filename = 'excelrincianpendapatan.xlsx';
        $writer = new Xlsx($spreadsheet);
        $tempPath = storage_path("app/public/{$filename}");
        $writer->save($tempPath);

        // Unduh file
        return response()->download($tempPath)->deleteFileAfterSend(true);
    }




    // LAPORAN GUBERNUR
    public function laporanGubernur()
    {
        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");
        return view('laporan.laporan_gubernur', compact('jadwal'));
    }

    public function laporanGubernurPdf(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required',
        ]);

        $jadwal = $request->input('jadwal');
        $tahun = $request->input('tahun');
        $bulan = $request->input('bulan');
        $end   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulan-01")->endOfMonth()->toDateString();

        $bulanlalu = $bulan - 1;

        $start   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulanlalu-01")->endOfMonth()->toDateString();

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $target1 = $this->hitungTarget($targets, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaian1 = $target1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $target1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'target' => $target1,
                    'capaian' => $capaian1,
                ];
            }

            $pdf = Pdf::loadView('laporan.laporan_gubernur_pdf', compact('rows', 'rows2', 'rows3', 'end', 'start'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_gubernur.pdf');
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', '1')
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $targetperubahan1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }

            $pdf = Pdf::loadView('laporan.laporan_gubernur_papbd_pdf', compact('rows', 'rows2', 'rows3', 'end', 'start'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_gubernur_papbd.pdf');
        }
    }

    public function laporanGubernurRincianPdf(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required',
        ]);

        $jadwal = $request->input('jadwal');
        $tahun = $request->input('tahun');
        $bulan = $request->input('bulan');
        $end   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulan-01")->endOfMonth()->toDateString();

        $bulanlalu = $bulan - 1;

        $start   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulanlalu-01")->endOfMonth()->toDateString();

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();



            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $target6 = $this->hitungTarget($targets, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $target6 > 0) {
                                        $capaian6 = $target6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $target6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'target' => $target6,
                                            'capaian' => $capaian6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $target1 = $this->hitungTarget($targets, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaian1 = $target1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $target1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'target' => $target1,
                    'capaian' => $capaian1,
                ];
            }

            $pdf = Pdf::loadView('laporan.laporan_rincian_gubernur_pdf', compact('rows', 'rows2', 'rows3', 'end', 'start'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_rincian_gubernur.pdf');
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', '1')
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetinduk6 = $this->hitungTarget($targetsinduk, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                    ]);
                                    $targetperubahan6 = $this->hitungTarget($targetsperubahan, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $targetinduk6 > 0 || $targetperubahan6 > 0) {
                                        $capaianinduk6 = $targetinduk6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetinduk6) * 100 : 0;
                                        $capaianperubahan6 = $targetperubahan6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetperubahan6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'targetinduk' => $targetinduk6,
                                            'targetperubahan' => $targetperubahan6,
                                            'capaianinduk' => $capaianinduk6,
                                            'capaianperubahan' => $capaianperubahan6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $targetperubahan1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }

            $pdf = Pdf::loadView('laporan.laporan_gubernur_papbd_pdf', compact('rows2', 'rows3', 'end', 'start'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_gubernur_papbd.pdf');
        }
    }

    public function exportExcelLaporanGubernur(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required',
        ]);

        $jadwal = $request->input('jadwal');
        $tahun = $request->input('tahun');
        $bulan = $request->input('bulan');

        $bulanlalu = $bulan - 1;

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:C2');
            $sheet->setCellValue('C1', 'Target');
            $sheet->mergeCells('D1:F1');
            $sheet->setCellValue('D1', 'Realisasi Rekening');
            $sheet->setCellValue('D2', 'BULAN LALU');
            $sheet->setCellValue('E2', 'BULAN INI');
            $sheet->setCellValue('F2', 'SAMPAI DENGAN BULAN INI');
            $sheet->mergeCells('G1:G2');
            $sheet->setCellValue('G1', '% Capaian');

            // Data dummy, kamu bisa load dari database
            $data = [];

            // Buat array laporan akhir
            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0 || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $row = 3;
            foreach ($rows as $item1) {
                $sheet->setCellValue("A$row", $item1['kode']);
                $sheet->setCellValue("B$row", $item1['nama']);
                $sheet->setCellValue("C$row", $item1['target']);
                $sheet->setCellValue("D$row", $item1['totalbulanlalu']);
                $sheet->setCellValue("E$row", $item1['totalbulanini']);
                $sheet->setCellValue("F$row", $item1['total']);
                $sheet->setCellValue("G$row", $item1['capaian']);
                $row++;
            }
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['target']);
                $sheet->setCellValue("D$row", $item2['totalbulanlalu']);
                $sheet->setCellValue("D$row", $item2['totalbulanini']);
                $sheet->setCellValue("D$row", $item2['total']);
                $sheet->setCellValue("E$row", $item2['capaian']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporankabgubernur.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 2)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:D1');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('C2', 'INDUK');
            $sheet->setCellValue('D2', 'PERUBAHAN');
            $sheet->mergeCells('E1:G1');
            $sheet->setCellValue('E1', 'Realisasi Rekening');
            $sheet->setCellValue('E2', 'BULAN LALU');
            $sheet->setCellValue('F2', 'BULAN INI');
            $sheet->setCellValue('G2', 'SAMPAI DENGAN BULAN INI');
            $sheet->mergeCells('H1:I1');
            $sheet->setCellValue('H1', '% Capaian');
            $sheet->setCellValue('H2', '% INDUK');
            $sheet->setCellValue('I2', '% PERUBAHAN');

            // Data dummy, kamu bisa load dari database
            $data = [];

            $rows = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0 || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 +  $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => false,
                            ];
                        }
                    }
                }
            }

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    if (!($r2->kd_rek2 != 1)) {
                        continue;
                    }
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? (($totalbulanini1 +  $totalbulanlalu1) / $targetperubahan1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }

            $row = 3;
            foreach ($rows as $item1) {
                $sheet->setCellValue("A$row", $item1['kode']);
                $sheet->setCellValue("B$row", $item1['nama']);
                $sheet->setCellValue("C$row", $item1['targetinduk']);
                $sheet->setCellValue("D$row", $item1['targetperubahan']);
                $sheet->setCellValue("E$row", $item1['totalbulanlalu']);
                $sheet->setCellValue("F$row", $item1['totalbulanini']);
                $sheet->setCellValue("G$row", $item1['total']);
                $sheet->setCellValue("H$row", $item1['capaianinduk']);
                $sheet->setCellValue("I$row", $item1['capaianperubahan']);
                $row++;
            }
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['targetinduk']);
                $sheet->setCellValue("D$row", $item2['targetperubahan']);
                $sheet->setCellValue("E$row", $item2['totalbulanlalu']);
                $sheet->setCellValue("F$row", $item2['totalbulanini']);
                $sheet->setCellValue("G$row", $item2['total']);
                $sheet->setCellValue("H$row", $item2['capaianinduk']);
                $sheet->setCellValue("I$row", $item2['capaianperubahan']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporankabpapbdgubernur.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        }
    }

    public function exportExcelLaporanRincianGubernur(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required',
        ]);

        $jadwal = $request->input('jadwal');
        $tahun = $request->input('tahun');
        $bulan = $request->input('bulan');

        $bulanlalu = $bulan - 1;

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:C2');
            $sheet->setCellValue('C1', 'Target');
            $sheet->mergeCells('D1:F1');
            $sheet->setCellValue('D1', 'Realisasi Rekening');
            $sheet->setCellValue('D2', 'BULAN LALU');
            $sheet->setCellValue('E2', 'BULAN INI');
            $sheet->setCellValue('F2', 'SAMPAI DENGAN BULAN INI');
            $sheet->mergeCells('G1:G2');
            $sheet->setCellValue('G1', '% Capaian');

            // Data dummy, kamu bisa load dari database
            $data = [];

            // Buat array laporan akhir
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $target6 = $this->hitungTarget($targets, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $target6 > 0) {
                                        $capaian6 = $target6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $target6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'target' => $target6,
                                            'capaian' => $capaian6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $row = 3;
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['target']);
                $sheet->setCellValue("D$row", $item2['totalbulanlalu']);
                $sheet->setCellValue("E$row", $item2['totalbulanini']);
                $sheet->setCellValue("F$row", $item2['total']);
                $sheet->setCellValue("G$row", $item2['capaian']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporanrinciangubernur.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', '1')
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:D1');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('C2', 'INDUK');
            $sheet->setCellValue('D2', 'PERUBAHAN');
            $sheet->mergeCells('E1:G1');
            $sheet->setCellValue('E1', 'Realisasi Rekening');
            $sheet->setCellValue('E2', 'BULAN LALU');
            $sheet->setCellValue('F2', 'BULAN INI');
            $sheet->setCellValue('G2', 'SAMPAI DENGAN BULAN INI');
            $sheet->mergeCells('H1:I1');
            $sheet->setCellValue('H1', '% Capaian');
            $sheet->setCellValue('H2', '% INDUK');
            $sheet->setCellValue('I2', '% PERUBAHAN');

            // Data dummy, kamu bisa load dari database
            $data = [];

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetinduk6 = $this->hitungTarget($targetsinduk, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                    ]);
                                    $targetperubahan6 = $this->hitungTarget($targetsperubahan, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $targetinduk6 > 0 || $targetperubahan6 > 0) {
                                        $capaianinduk6 = $targetinduk6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetinduk6) * 100 : 0;
                                        $capaianperubahan6 = $targetperubahan6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetperubahan6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'targetinduk' => $targetinduk6,
                                            'targetperubahan' => $targetperubahan6,
                                            'capaianinduk' => $capaianinduk6,
                                            'capaianperubahan' => $capaianperubahan6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $row = 3;
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['targetinduk']);
                $sheet->setCellValue("D$row", $item2['targetperubahan']);
                $sheet->setCellValue("E$row", $item2['totalbulanlalu']);
                $sheet->setCellValue("F$row", $item2['totalbulanini']);
                $sheet->setCellValue("G$row", $item2['total']);
                $sheet->setCellValue("H$row", $item2['capaianinduk']);
                $sheet->setCellValue("I$row", $item2['capaianperubahan']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporanrincianpapbdgubernur.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        }
    }

    public function laporanGubernurOpd()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');
        $jadwal = DB::select("SELECT * FROM ref_jadwal WHERE kd_jadwal <= 2");

        if (Auth::user()->hasRole('Admin')) {
            $d_opd = DB::select("SELECT * FROM ref_opd");
        } else {
            $d_opd = DB::select("SELECT * FROM ref_opd WHERE kd_opd = $opd_user");
        }
        return view('laporan.laporan_gubernur_opd', compact('jadwal', 'd_opd'));
    }

    public function laporanGubernurOpdPdf(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required',
            'opd' => 'required'
        ]);

        $tahun = $request->input('tahun');
        $bulan = $request->input('bulan');
        $jadwal = $request->input('jadwal');
        $opd = $request->input('opd');
        $bulanlalu = $bulan - 1;
        // dd($jadwal);
        $end   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulan-01")->endOfMonth()->toDateString();
        $start   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulanlalu-01")->endOfMonth()->toDateString();

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();
            $ref_opd = DB::table('ref_opd')->where('kd_opd', $opd)->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->where('kd_opd', '=', $opd)
                ->where('tahun', '=', $tahun)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('kd_jadwal', '=', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();


            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($totalbulanini2 + $totalbulanlalu2 / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($totalbulanini3 + $totalbulanlalu3 / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? ($totalbulanini4 + $totalbulanlalu4 / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? ($totalbulanini5 + $totalbulanlalu5 / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $target6 = $this->hitungTarget($targets, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $target6 > 0) {
                                        $capaian6 = $target6 > 0 ? ($totalbulanini6 + $totalbulanlalu6 / $target6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'target' => $target6,
                                            'capaian' => $capaian6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }

            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $target1 = $this->hitungTarget($targets, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaian1 = $target1 > 0 ? ($totalbulanini1 +  $totalbulanlalu1 / $target1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'target' => $target1,
                    'capaian' => $capaian1,
                ];
            }

            $pdf = Pdf::loadView('laporan.laporan_gubernur_opd_pdf', compact('rows2', 'rows3', 'end', 'start', 'ref_opd'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_gubernur_opd.pdf');
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();
            $ref_opd = DB::table('ref_opd')->where('kd_opd', $opd)->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_opd', '=', $opd)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('tahun', '=', $tahun)
                ->where('kd_opd', '=', $opd)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('kd_jadwal', '=', '1')
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetinduk6 = $this->hitungTarget($targetsinduk, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                    ]);
                                    $targetperubahan6 = $this->hitungTarget($targetsperubahan, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $targetinduk6 > 0 || $targetperubahan6 > 0) {
                                        $capaianinduk6 = $targetinduk6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetinduk6) * 100 : 0;
                                        $capaianperubahan6 = $targetperubahan6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetperubahan6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'targetinduk' => $targetinduk6,
                                            'targetperubahan' => $targetperubahan6,
                                            'capaianinduk' => $capaianinduk6,
                                            'capaianperubahan' => $capaianperubahan6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $rows3 = [];
            foreach ($rek1 as $r1) {
                $totalbulanini1 = $this->hitungTotal($transaksinow, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $totalbulanlalu1 = $this->hitungTotal($transaksilater, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetinduk1 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                ]);
                $capaianinduk1 = $targetinduk1 > 0 ? ($totalbulanini1 +  $totalbulanlalu1 / $targetinduk1) * 100 : 0;
                $capaianperubahan1 = $targetperubahan1 > 0 ? ($totalbulanini1 +  $totalbulanlalu1 / $targetperubahan1) * 100 : 0;
                $rows3[] = [
                    'total' => $totalbulanini1 + $totalbulanlalu1,
                    'totalbulanini' => $totalbulanini1,
                    'totalbulanlalu' => $totalbulanlalu1,
                    'targetinduk' => $targetinduk1,
                    'targetperubahan' => $targetperubahan1,
                    'capaianinduk' => $capaianinduk1,
                    'capaianperubahan' => $capaianperubahan1,
                ];
            }
            $pdf = Pdf::loadView('laporan.laporan_gubernur_opd_papbd_pdf', compact('rows2', 'rows3', 'end', 'start', 'ref_opd'))->setPaper('folio', 'landscape');

            return $pdf->download('laporan_gubernur_opd_papbd.pdf');
        }
    }

    public function exportExcelLaporanGubernurOpd(Request $request)
    {
        $this->validate($request, [
            'jadwal' => 'required',
            'bulan' => 'required',
            'tahun' => 'required',
            'opd' => 'required'
        ]);

        $tahun = $request->input('tahun');
        $bulan = $request->input('bulan');
        $jadwal = $request->input('jadwal');
        $opd = $request->input('opd');
        $bulanlalu = $bulan - 1;

        $end   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulan-01")->endOfMonth()->toDateString();
        $start   = Carbon::createFromFormat('Y-m-d', "$tahun-$bulanlalu-01")->endOfMonth()->toDateString();

        if ($jadwal == 1) {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->where('kd_opd', '=', $opd)
                ->where('tahun', '=', $tahun)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targets = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('kd_jadwal', '=', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:C2');
            $sheet->setCellValue('C1', 'Target');
            $sheet->mergeCells('D1:F1');
            $sheet->setCellValue('D1', 'Realisasi Rekening');
            $sheet->setCellValue('D2', 'BULAN LALU');
            $sheet->setCellValue('E2', 'BULAN INI');
            $sheet->setCellValue('F2', 'SAMPAI DENGAN BULAN INI');
            $sheet->mergeCells('G1:G2');
            $sheet->setCellValue('G1', '% Capaian');

            // Data dummy, kamu bisa load dari database
            $data = [];


            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $target2 = $this->hitungTarget($targets, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $target2 > 0) {
                        $capaian2 = $target2 > 0 ? ($totalbulanini2 + $totalbulanlalu2 / $target2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'target' => $target2,
                            'capaian' => $capaian2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $target3 = $this->hitungTarget($targets, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $target3 > 0) {
                            $capaian3 = $target3 > 0 ? ($totalbulanini3 + $totalbulanlalu3 / $target3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'target' => $target3,
                                'capaian' => $capaian3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $target4 = $this->hitungTarget($targets, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $target4 > 0) {
                                $capaian4 = $target4 > 0 ? ($totalbulanini4 + $totalbulanlalu4 / $target4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'target' => $target4,
                                    'capaian' => $capaian4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $target5 = $this->hitungTarget($targets, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $target5 > 0) {
                                    $capaian5 = $target5 > 0 ? ($totalbulanini5 + $totalbulanlalu5 / $target5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'target' => $target5,
                                        'capaian' => $capaian5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $target6 = $this->hitungTarget($targets, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $target6 > 0) {
                                        $capaian6 = $target6 > 0 ? ($totalbulanini6 + $totalbulanlalu6 / $target6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'target' => $target6,
                                            'capaian' => $capaian6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }


            $row = 3;
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['target']);
                $sheet->setCellValue("D$row", $item2['totalbulanlalu']);
                $sheet->setCellValue("E$row", $item2['totalbulanini']);
                $sheet->setCellValue("F$row", $item2['total']);
                $sheet->setCellValue("G$row", $item2['capaian']);
                $row++;
            }

            // Simpan ke file sementara
            $filename = 'laporangubernuropd.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        } else {
            // Ambil data semua level
            $rek1 = DB::table('ref_rek1')->get();
            $rek2 = DB::table('ref_rek2')->get();
            $rek3 = DB::table('ref_rek3')->get();
            $rek4 = DB::table('ref_rek4')->get();
            $rek5 = DB::table('ref_rek5')->get();
            $rek6 = DB::table('ref_rek6')->get();

            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksinow = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '=', $bulan)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $transaksilater = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('tahun', '=', $tahun)
                ->whereMonth('tgl_transaksi', '<=', $bulanlalu)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('kd_jadwal', '=', '1')
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', '=', $opd)
                ->where('kd_jadwal', $jadwal)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();

            $spreadsheet = new Spreadsheet();
            $sheet = $spreadsheet->getActiveSheet();

            // Header
            $sheet->mergeCells('A1:A2');
            $sheet->setCellValue('A1', 'Kode Rekening');
            $sheet->mergeCells('B1:B2');
            $sheet->setCellValue('B1', 'Rekening');
            $sheet->mergeCells('C1:D1');
            $sheet->setCellValue('C1', 'Target');
            $sheet->setCellValue('C2', 'INDUK');
            $sheet->setCellValue('D2', 'PERUBAHAN');
            $sheet->mergeCells('E1:G1');
            $sheet->setCellValue('E1', 'Realisasi Rekening');
            $sheet->setCellValue('E2', 'BULAN LALU');
            $sheet->setCellValue('F2', 'BULAN INI');
            $sheet->setCellValue('G2', 'SAMPAI DENGAN BULAN INI');
            $sheet->mergeCells('H1:I1');
            $sheet->setCellValue('H1', '% Capaian');
            $sheet->setCellValue('H2', '% INDUK');
            $sheet->setCellValue('I2', '% PERUBAHAN');

            // Data dummy, kamu bisa load dari database
            $data = [];

            $rows2 = [];
            foreach ($rek1 as $r1) {
                foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                    $totalbulanini2 = $this->hitungTotal($transaksinow, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $totalbulanlalu2 = $this->hitungTotal($transaksilater, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetinduk2 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                    ]);
                    if ($totalbulanini2 > 0 || $totalbulanlalu2 > 0  || $targetinduk2 > 0 || $targetperubahan2 > 0) {
                        $capaianinduk2 = $targetinduk2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetinduk2) * 100 : 0;
                        $capaianperubahan2 = $targetperubahan2 > 0 ? (($totalbulanini2 + $totalbulanlalu2) / $targetperubahan2) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                            'nama' => $r2->nm_rek2,
                            'total' => $totalbulanini2 + $totalbulanlalu2,
                            'totalbulanini' => $totalbulanini2,
                            'totalbulanlalu' => $totalbulanlalu2,
                            'targetinduk' => $targetinduk2,
                            'targetperubahan' => $targetperubahan2,
                            'capaianinduk' => $capaianinduk2,
                            'capaianperubahan' => $capaianperubahan2,
                            'bold' => true,
                        ];
                    }
                    foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                        $totalbulanini3 = $this->hitungTotal($transaksinow, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $totalbulanlalu3 = $this->hitungTotal($transaksilater, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetinduk3 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                        ]);
                        if ($totalbulanini3 > 0 || $totalbulanlalu3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                            $capaianinduk3 = $targetinduk3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetinduk3) * 100 : 0;
                            $capaianperubahan3 = $targetperubahan3 > 0 ? (($totalbulanini3 + $totalbulanlalu3) / $targetperubahan3) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                                'nama' => $r3->nm_rek3,
                                'total' => $totalbulanini3 + $totalbulanlalu3,
                                'totalbulanini' => $totalbulanini3,
                                'totalbulanlalu' => $totalbulanlalu3,
                                'targetinduk' => $targetinduk3,
                                'targetperubahan' => $targetperubahan3,
                                'capaianinduk' => $capaianinduk3,
                                'capaianperubahan' => $capaianperubahan3,
                                'bold' => true,
                            ];
                        }
                        foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                            $totalbulanini4 = $this->hitungTotal($transaksinow, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $totalbulanlalu4 = $this->hitungTotal($transaksilater, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetinduk4 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                            ]);
                            if ($totalbulanini4 > 0 || $totalbulanlalu4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                                $capaianinduk4 = $targetinduk4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetinduk4) * 100 : 0;
                                $capaianperubahan4 = $targetperubahan4 > 0 ? (($totalbulanini4 + $totalbulanlalu4) / $targetperubahan4) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                    'nama' => $r4->nm_rek4,
                                    'total' => $totalbulanini4 + $totalbulanlalu4,
                                    'totalbulanini' => $totalbulanini4,
                                    'totalbulanlalu' => $totalbulanlalu4,
                                    'targetinduk' => $targetinduk4,
                                    'targetperubahan' => $targetperubahan4,
                                    'capaianinduk' => $capaianinduk4,
                                    'capaianperubahan' => $capaianperubahan4,
                                    'bold' => false,
                                ];
                            }
                            foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                                $totalbulanini5 = $this->hitungTotal($transaksinow, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $totalbulanlalu5 = $this->hitungTotal($transaksilater, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                    'kd_rek1' => $r1->kd_rek1,
                                    'kd_rek2' => $r2->kd_rek2,
                                    'kd_rek3' => $r3->kd_rek3,
                                    'kd_rek4' => $r4->kd_rek4,
                                    'kd_rek5' => $r5->kd_rek5,
                                ]);
                                if ($totalbulanini5 > 0 || $totalbulanlalu5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                    $capaianinduk5 = $targetinduk5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetinduk5) * 100 : 0;
                                    $capaianperubahan5 = $targetperubahan5 > 0 ? (($totalbulanini5 + $totalbulanlalu5) / $targetperubahan5) * 100 : 0;
                                    $rows2[] = [
                                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                        'nama' => $r5->nm_rek5,
                                        'total' => $totalbulanini5 + $totalbulanlalu5,
                                        'totalbulanini' => $totalbulanini5,
                                        'totalbulanlalu' => $totalbulanlalu5,
                                        'targetinduk' => $targetinduk5,
                                        'targetperubahan' => $targetperubahan5,
                                        'capaianinduk' => $capaianinduk5,
                                        'capaianperubahan' => $capaianperubahan5,
                                        'bold' => false,
                                    ];
                                }
                                foreach ($rek6->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4)->where('kd_rek5', $r5->kd_rek5) as $r6) {
                                    $totalbulanini6 = $this->hitungTotal($transaksinow, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $totalbulanlalu6 = $this->hitungTotal($transaksilater, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    $targetinduk6 = $this->hitungTarget($targetsinduk, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                    ]);
                                    $targetperubahan6 = $this->hitungTarget($targetsperubahan, [
                                        'kd_rek1' => $r1->kd_rek1,
                                        'kd_rek2' => $r2->kd_rek2,
                                        'kd_rek3' => $r3->kd_rek3,
                                        'kd_rek4' => $r4->kd_rek4,
                                        'kd_rek5' => $r5->kd_rek5,
                                        'kd_rek6' => $r6->kd_rek6,
                                    ]);
                                    if ($totalbulanini6 > 0 || $totalbulanlalu6 > 0 || $targetinduk6 > 0 || $targetperubahan6 > 0) {
                                        $capaianinduk6 = $targetinduk6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetinduk6) * 100 : 0;
                                        $capaianperubahan6 = $targetperubahan6 > 0 ? (($totalbulanini6 + $totalbulanlalu6) / $targetperubahan6) * 100 : 0;
                                        $rows2[] = [
                                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}.{$r6->kd_rek6}",
                                            'nama' => $r6->nm_rek6,
                                            'total' => $totalbulanini6 + $totalbulanlalu6,
                                            'totalbulanini' => $totalbulanini6,
                                            'totalbulanlalu' => $totalbulanlalu6,
                                            'targetinduk' => $targetinduk6,
                                            'targetperubahan' => $targetperubahan6,
                                            'capaianinduk' => $capaianinduk6,
                                            'capaianperubahan' => $capaianperubahan6,
                                            'bold' => false,
                                        ];
                                    }
                                }
                            }
                        }
                    }
                }
            }
            $row = 3;
            foreach ($rows2 as $item2) {
                $sheet->setCellValue("A$row", $item2['kode']);
                $sheet->setCellValue("B$row", $item2['nama']);
                $sheet->setCellValue("C$row", $item2['targetinduk']);
                $sheet->setCellValue("D$row", $item2['targetperubahan']);
                $sheet->setCellValue("E$row", $item2['totalbulanlalu']);
                $sheet->setCellValue("F$row", $item2['totalbulanini']);
                $sheet->setCellValue("G$row", $item2['total']);
                $sheet->setCellValue("H$row", $item2['capaianinduk']);
                $sheet->setCellValue("I$row", $item2['capaianperubahan']);
                $row++;
            }
            // Simpan ke file sementara
            $filename = 'laporangubernuropdpapbd.xlsx';
            $writer = new Xlsx($spreadsheet);
            $tempPath = storage_path("app/public/{$filename}");
            $writer->save($tempPath);

            // Unduh file
            return response()->download($tempPath)->deleteFileAfterSend(true);
        }
    }

    private function hitungTotal($collection, $keys)
    {
        return $collection->filter(function ($item) use ($keys) {
            foreach ($keys as $key => $val) {
                if ($item->$key != $val) return false;
            }
            return true;
        })->sum('total');
    }
    private function hitungTarget($targets, $keys)
    {
        return $targets->filter(function ($item) use ($keys) {
            foreach ($keys as $key => $val) {
                if ($item->$key != $val) return false;
            }
            return true;
        })->sum('total');
    }
}
