<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Contracts\Role;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $user =  Auth::user();
        $role = $user->getRoleNames()->first();
        $opd_user = DB::table('users')
            ->join('tbl_user_opd', 'tbl_user_opd.id_user', '=', 'users.id')
            ->where('users.id', $user->id)
            ->value('tbl_user_opd.kd_opd');


        // Ambil data semua level
        $rek1 = DB::table('ref_rek1')->get();
        $rek2 = DB::table('ref_rek2')->get();
        $rek3 = DB::table('ref_rek3')->get();
        $rek4 = DB::table('ref_rek4')->get();
        $rek5 = DB::table('ref_rek5')->get();
        $rek6 = DB::table('ref_rek6')->get();

        if (Auth::user()->hasRole('Admin')) {
            $target = DB::select("SELECT SUM(nilai) AS target_pendapatan FROM tbl_target WHERE tahun = 2025 AND kd_jadwal = 1");
            $realisasi = DB::select("SELECT SUM(nilai) AS realisasi_pendapatan FROM tbl_pendapatan WHERE tahun = 2025");

            $target_pendapatan = $target[0]->target_pendapatan ?? 0;
            $realisasi_pendapatan = $realisasi[0]->realisasi_pendapatan ?? 0;

            $presentase_pendapatan = $target_pendapatan > 0
                ? ($realisasi_pendapatan / $target_pendapatan) * 100
                : 0;
            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 1)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 2)
                ->groupBy('kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
        } else {
            $target = DB::select("SELECT SUM(nilai) AS target_pendapatan FROM tbl_target WHERE tahun = 2025 AND kd_jadwal = 1 AND kd_opd = $opd_user");
            $realisasi = DB::select("SELECT SUM(nilai) AS realisasi_pendapatan FROM tbl_pendapatan WHERE tahun = 2025 AND kd_opd = $opd_user");

            $target_pendapatan = $target[0]->target_pendapatan ?? 0;
            $realisasi_pendapatan = $realisasi[0]->realisasi_pendapatan ?? 0;

            $presentase_pendapatan = $target_pendapatan > 0
                ? ($realisasi_pendapatan / $target_pendapatan) * 100
                : 0;
            // Ambil total dari transaksi untuk kd_rek1 - kd_rek6
            $transaksi = DB::table('tbl_pendapatan')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_opd', $opd_user)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsinduk = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 1)
                ->where('kd_opd', $opd_user)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
            $targetsperubahan = DB::table('tbl_target')
                ->select(
                    'kd_opd',
                    'kd_rek1',
                    'kd_rek2',
                    'kd_rek3',
                    'kd_rek4',
                    'kd_rek5',
                    'kd_rek6',
                    DB::raw('SUM(nilai) as total')
                )
                ->where('kd_jadwal', '=', 2)
                ->where('kd_opd', $opd_user)
                ->groupBy('kd_opd', 'kd_rek1', 'kd_rek2', 'kd_rek3', 'kd_rek4', 'kd_rek5', 'kd_rek6')
                ->get();
        }

        // Buat array laporan akhir
        $rows1 = [];

        foreach ($rek1 as $r1) {
            foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                if (!($r1->kd_rek1 == 4 && $r2->kd_rek2 == 1)) {
                    continue;
                }
                $total2 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                    'kd_rek2' => $r2->kd_rek2,
                ]);
                $targetinduk2 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                    'kd_rek2' => $r2->kd_rek2,
                ]);
                $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                    'kd_rek2' => $r2->kd_rek2,
                ]);
                if ($total2 > 0 || $targetinduk2 > 0 ||  $targetperubahan2 > 0) {
                    $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                    $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                    $rows1[] = [
                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                        'nama' => $r2->nm_rek2,
                        'total' => $total2,
                        'targetinduk' => $targetinduk2,
                        'targetperubahan' => $targetperubahan2,
                        'capaianinduk' => $capaianinduk2,
                        'capaianperubahan' => $capaianperubahan2,
                        'bold' => true,
                    ];
                }
                foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                    $total3 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                        'kd_rek3' => $r3->kd_rek3,
                    ]);
                    $targetinduk3 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                        'kd_rek3' => $r3->kd_rek3,
                    ]);
                    $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                        'kd_rek3' => $r3->kd_rek3,
                    ]);
                    if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                        $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                        $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                        $rows1[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                            'nama' => $r3->nm_rek3,
                            'total' => $total3,
                            'targetinduk' => $targetinduk3,
                            'targetperubahan' => $targetperubahan3,
                            'capaianinduk' => $capaianinduk3,
                            'capaianperubahan' => $capaianperubahan3,
                        ];
                    }
                }
            }
        }
        $rows2 = [];
        foreach ($rek1 as $r1) {
            foreach ($rek2->where('kd_rek1', $r1->kd_rek1) as $r2) {
                if (!($r2->kd_rek2 != 1)) {
                    continue;
                }
                $total2 = $this->hitungTotal($transaksi, [
                    'kd_rek1' => $r1->kd_rek1,
                    'kd_rek2' => $r2->kd_rek2,
                ]);
                $targetinduk2 = $this->hitungTarget($targetsinduk, [
                    'kd_rek1' => $r1->kd_rek1,
                    'kd_rek2' => $r2->kd_rek2,
                ]);
                $targetperubahan2 = $this->hitungTarget($targetsperubahan, [
                    'kd_rek1' => $r1->kd_rek1,
                    'kd_rek2' => $r2->kd_rek2,
                ]);
                if ($total2 > 0 || $targetinduk2 > 0 ||  $targetperubahan2 > 0) {
                    $capaianinduk2 = $targetinduk2 > 0 ? ($total2 / $targetinduk2) * 100 : 0;
                    $capaianperubahan2 = $targetperubahan2 > 0 ? ($total2 / $targetperubahan2) * 100 : 0;
                    $rows2[] = [
                        'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}",
                        'nama' => $r2->nm_rek2,
                        'total' => $total2,
                        'targetinduk' => $targetinduk2,
                        'targetperubahan' => $targetperubahan2,
                        'capaianinduk' => $capaianinduk2,
                        'capaianperubahan' => $capaianperubahan2,
                        'bold' => true,
                    ];
                }
                foreach ($rek3->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2) as $r3) {
                    $total3 = $this->hitungTotal($transaksi, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                        'kd_rek3' => $r3->kd_rek3,
                    ]);
                    $targetinduk3 = $this->hitungTarget($targetsinduk, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                        'kd_rek3' => $r3->kd_rek3,
                    ]);
                    $targetperubahan3 = $this->hitungTarget($targetsperubahan, [
                        'kd_rek1' => $r1->kd_rek1,
                        'kd_rek2' => $r2->kd_rek2,
                        'kd_rek3' => $r3->kd_rek3,
                    ]);
                    if ($total3 > 0 || $targetinduk3 > 0 || $targetperubahan3 > 0) {
                        $capaianinduk3 = $targetinduk3 > 0 ? ($total3 / $targetinduk3) * 100 : 0;
                        $capaianperubahan3 = $targetperubahan3 > 0 ? ($total3 / $targetperubahan3) * 100 : 0;
                        $rows2[] = [
                            'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}",
                            'nama' => $r3->nm_rek3,
                            'total' => $total3,
                            'targetinduk' => $targetinduk3,
                            'targetperubahan' => $targetperubahan3,
                            'capaianinduk' => $capaianinduk3,
                            'capaianperubahan' => $capaianperubahan3,
                        ];
                    }
                    foreach ($rek4->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3) as $r4) {
                        $total4 = $this->hitungTotal($transaksi, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                            'kd_rek4' => $r4->kd_rek4,
                        ]);
                        $targetinduk4 = $this->hitungTarget($targetsinduk, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                            'kd_rek4' => $r4->kd_rek4,
                        ]);
                        $targetperubahan4 = $this->hitungTarget($targetsperubahan, [
                            'kd_rek1' => $r1->kd_rek1,
                            'kd_rek2' => $r2->kd_rek2,
                            'kd_rek3' => $r3->kd_rek3,
                            'kd_rek4' => $r4->kd_rek4,
                        ]);
                        if ($total4 > 0 || $targetinduk4 > 0 || $targetperubahan4 > 0) {
                            $capaianinduk4 = $targetinduk4 > 0 ? ($total4 / $targetinduk4) * 100 : 0;
                            $capaianperubahan4 = $targetperubahan4 > 0 ? ($total4 / $targetperubahan4) * 100 : 0;
                            $rows2[] = [
                                'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}",
                                'nama' => $r4->nm_rek4,
                                'total' => $total4,
                                'targetinduk' => $targetinduk4,
                                'targetperubahan' => $targetperubahan4,
                                'capaianinduk' => $capaianinduk4,
                                'capaianperubahan' => $capaianperubahan4,
                            ];
                        }
                        foreach ($rek5->where('kd_rek1', $r1->kd_rek1)->where('kd_rek2', $r2->kd_rek2)->where('kd_rek3', $r3->kd_rek3)->where('kd_rek4', $r4->kd_rek4) as $r5) {
                            $total5 = $this->hitungTotal($transaksi, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                                'kd_rek5' => $r5->kd_rek5,
                            ]);
                            $targetinduk5 = $this->hitungTarget($targetsinduk, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                                'kd_rek5' => $r5->kd_rek5,
                            ]);
                            $targetperubahan5 = $this->hitungTarget($targetsperubahan, [
                                'kd_rek1' => $r1->kd_rek1,
                                'kd_rek2' => $r2->kd_rek2,
                                'kd_rek3' => $r3->kd_rek3,
                                'kd_rek4' => $r4->kd_rek4,
                                'kd_rek5' => $r5->kd_rek5,
                            ]);
                            if ($total5 > 0 || $targetinduk5 > 0 || $targetperubahan5 > 0) {
                                $capaianinduk5 = $targetinduk5 > 0 ? ($total5 / $targetinduk5) * 100 : 0;
                                $capaianperubahan5 = $targetperubahan5 > 0 ? ($total5 / $targetperubahan5) * 100 : 0;
                                $rows2[] = [
                                    'kode' => "{$r1->kd_rek1}.{$r2->kd_rek2}.{$r3->kd_rek3}.{$r4->kd_rek4}.{$r5->kd_rek5}",
                                    'nama' => $r5->nm_rek5,
                                    'total' => $total5,
                                    'targetinduk' => $targetinduk5,
                                    'targetperubahan' => $targetperubahan5,
                                    'capaianinduk' => $capaianinduk5,
                                    'capaianperubahan' => $capaianperubahan5,
                                ];
                            }
                        }
                    }
                }
            }
        }

        $rows3 = [];
        foreach ($rek1 as $r1) {
            $total1 = $this->hitungTotal($transaksi, [
                'kd_rek1' => $r1->kd_rek1,
            ]);
            $targetinduk1 = $this->hitungTarget($targetsinduk, [
                'kd_rek1' => $r1->kd_rek1,
            ]);
            $targetperubahan1 = $this->hitungTarget($targetsperubahan, [
                'kd_rek1' => $r1->kd_rek1,
            ]);
            $capaianinduk1 = $targetinduk1 > 0 ? ($total1 / $targetinduk1) * 100 : 0;
            $capaianperubahan1 = $targetperubahan1 > 0 ? ($total1 / $targetperubahan1) * 100 : 0;
            $rows3[] = [
                'total' => $total1,
                'targetinduk' => $targetinduk1,
                'targetperubahan' => $targetperubahan1,
                'capaianinduk' => $capaianinduk1,
                'capaianperubahan' => $capaianperubahan1,
            ];
        }

        $dataperopd = DB::select("SELECT A.kd_opd, A.nm_opd, A.r, A.t_induk, A.t_perubahan, A.r/A.t_induk*100 AS p_induk, A.r/A.t_perubahan*100 AS p_perubahan
				FROM (
				SELECT A.kd_opd, A.nm_opd, SUM(A.realisasi) AS r, SUM(A.targetinduk) AS t_induk, SUM(A.targetperubahan) AS t_perubahan, 0 AS presentaseinduk, 0 AS presentaseperubahan
        FROM (
        SELECT B.kd_opd, B.nm_opd, SUM(nilai) AS realisasi, 0 AS targetinduk, 0 AS targetperubahan, 0 AS presentaseinduk, 0 AS presentaseperubahan
        FROM tbl_pendapatan AS A INNER JOIN
        ref_opd AS B ON A.kd_opd = B.kd_opd
        GROUP BY B.kd_opd, B.nm_opd

        UNION ALL

        SELECT B.kd_opd, B.nm_opd, 0 AS realisasi, SUM(nilai) AS targetinduk, 0 AS targetperubahan, 0 AS presentaseinduk, 0 AS presentaseperubahan
        FROM tbl_target AS A INNER JOIN
        ref_opd AS B ON A.kd_opd = B.kd_opd
				WHERE kd_jadwal = 1
        GROUP BY B.kd_opd, B.nm_opd

				UNION ALL

				 SELECT B.kd_opd, B.nm_opd, 0 AS realisasi, 0 AS targetinduk, SUM(nilai) AS targetperubahan, 0 AS presentaseinduk, 0 AS presentaseperubahan
        FROM tbl_target AS A INNER JOIN
        ref_opd AS B ON A.kd_opd = B.kd_opd
				WHERE kd_jadwal = 2
        GROUP BY B.kd_opd, B.nm_opd

        ) AS A
				GROUP BY A.kd_opd, A.nm_opd
				)AS A
        GROUP BY A.kd_opd, A.nm_opd, A.r, A.t_induk, A.t_perubahan
        ORDER BY A.kd_opd
        ");

        return view('dashboard', compact('dataperopd', 'target_pendapatan', 'realisasi_pendapatan', 'presentase_pendapatan', 'rows1', 'rows2', 'rows3', 'user', 'opd_user'));
    }
    private function hitungTotal($collection, $keys)
    {
        return $collection->filter(function ($item) use ($keys) {
            foreach ($keys as $key => $val) {
                if ($item->$key != $val) return false;
            }
            return true;
        })->sum('total');
    }
    private function hitungTarget($targets, $keys)
    {
        return $targets->filter(function ($item) use ($keys) {
            foreach ($keys as $key => $val) {
                if ($item->$key != $val) return false;
            }
            return true;
        })->sum('total');
    }
    public function template()
    {
        return view('layouts.default');
    }
}
