# Panduan Deployment Silapad App ke cPanel

## Persyaratan Sistem

### Server Requirements
- PHP 8.2 atau lebih tinggi
- MySQL 5.7+ atau MariaDB 10.3+
- Composer
- Node.js dan NPM (untuk build assets)
- cPanel dengan File Manager atau SSH access

### Extensions PHP yang diperlukan:
- BCMath
- Ctype
- Fileinfo
- JSON
- Mbstring
- OpenSSL
- PDO
- Tokenizer
- XML
- Zip
- GD (untuk PDF generation)

## Langkah-Langkah Deployment

### 1. Persiapan File Project

1. **Compress project** menjadi ZIP file, exclude folder berikut:
   - `node_modules/`
   - `vendor/`
   - `.env`
   - `storage/logs/`

### 2. Upload ke cPanel

1. Login ke cPanel
2. Buka **File Manager**
3. Upload file ZIP ke folder `public_html/`
4. Extract file ZIP
5. Pindahkan semua file dari folder project ke root `public_html/`

### 3. Konfigurasi Database

1. Buka **MySQL Databases** di cPanel
2. Buat database baru (misal: `yourdomain_silapad`)
3. Buat user database dan berikan privilege
4. Catat nama database, username, dan password

### 4. Konfigurasi Environment

1. Copy file `.env.production` menjadi `.env`
2. Edit file `.env` dengan detail berikut:

```env
APP_NAME="Silapad App"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

DB_CONNECTION=mysql
DB_HOST=localhost
DB_DATABASE=yourdomain_silapad
DB_USERNAME=yourdomain_user
DB_PASSWORD=your_password

# Email settings (sesuaikan dengan cPanel email)
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=noreply@yourdomain.com
MAIL_PASSWORD=your_email_password
MAIL_ENCRYPTION=tls
```

### 5. Install Dependencies

#### Via Terminal (jika tersedia SSH):
```bash
cd public_html
composer install --optimize-autoloader --no-dev
npm ci
npm run build
```

#### Via cPanel File Manager (alternatif):
1. Upload folder `vendor/` yang sudah di-generate dari local
2. Upload folder `public/build/` hasil dari `npm run build`

### 6. Generate Application Key

Via Terminal:
```bash
php artisan key:generate
```

Via File Manager:
1. Edit file `.env`
2. Tambahkan APP_KEY dengan value random 32 karakter

### 7. Setup Database

```bash
php artisan migrate
php artisan db:seed
```

### 8. Optimize Laravel

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### 9. Set File Permissions

```bash
chmod -R 755 storage/
chmod -R 755 bootstrap/cache/
```

Via File Manager:
- Klik kanan folder → Permissions → Set to 755

### 10. Konfigurasi Domain

#### Untuk Domain Utama:
- File sudah berada di `public_html/`
- Laravel akan mengarah ke folder `public/`

#### Untuk Subdomain:
1. Buat subdomain di cPanel
2. Set document root ke `public_html/silapad/public/`

### 11. Setup SSL Certificate

1. Di cPanel, buka **SSL/TLS**
2. Install SSL Certificate (Let's Encrypt gratis)
3. Enable "Force HTTPS Redirect"

## Troubleshooting

### Error 500 Internal Server Error
- Periksa file `.env` sudah benar
- Pastikan APP_KEY sudah di-generate
- Cek permissions folder storage dan bootstrap/cache
- Periksa error log di cPanel

### Database Connection Error
- Pastikan detail database di `.env` benar
- Test koneksi database via phpMyAdmin
- Pastikan user database memiliki privilege yang tepat

### File Permission Issues
- Set folder storage ke 755 atau 777
- Set folder bootstrap/cache ke 755 atau 777

### Assets tidak muncul
- Pastikan file CSS/JS sudah ter-build: `npm run build`
- Periksa path assets di file blade
- Cek file `vite.config.js` untuk asset URL

## Maintenance

### Update Project:
1. Backup database dan files
2. Upload file baru
3. Jalankan: `composer install --no-dev`
4. Jalankan: `php artisan migrate`
5. Clear cache: `php artisan config:clear`

### Backup Otomatis:
- Setup cron job untuk backup database
- Backup files secara berkala via File Manager

## Security Checklist

- [x] APP_DEBUG=false di production
- [x] .env file tidak dapat diakses public
- [x] SSL Certificate aktif
- [x] File permissions yang aman
- [x] Database credentials yang kuat
- [x] Regular backup database dan files

## Kontak Support

Jika mengalami kesulitan, hubungi:
- Hosting provider untuk masalah server
- Developer untuk masalah aplikasi